/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.apache.commons.httpclient.methods;

import alluxio.underfs.gcs.org.apache.commons.httpclient.HttpConnection;
import alluxio.underfs.gcs.org.apache.commons.httpclient.HttpException;
import alluxio.underfs.gcs.org.apache.commons.httpclient.HttpMethodBase;
import alluxio.underfs.gcs.org.apache.commons.httpclient.HttpState;
import alluxio.underfs.gcs.org.apache.commons.httpclient.ProtocolException;
import alluxio.underfs.gcs.org.apache.commons.logging.Log;
import alluxio.underfs.gcs.org.apache.commons.logging.LogFactory;
import java.io.IOException;

public class HeadMethod
extends HttpMethodBase {
    private static final Log LOG = LogFactory.getLog(class$org$apache$commons$httpclient$methods$HeadMethod == null ? (class$org$apache$commons$httpclient$methods$HeadMethod = HeadMethod.class$("alluxio.underfs.gcs.org.apache.commons.httpclient.methods.HeadMethod")) : class$org$apache$commons$httpclient$methods$HeadMethod);
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$HeadMethod;

    public HeadMethod() {
        this.setFollowRedirects(true);
    }

    public HeadMethod(String uri) {
        super(uri);
        this.setFollowRedirects(true);
    }

    public String getName() {
        return "HEAD";
    }

    public void recycle() {
        super.recycle();
        this.setFollowRedirects(true);
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws HttpException, IOException {
        LOG.trace("enter HeadMethod.readResponseBody(HttpState, HttpConnection)");
        int bodyCheckTimeout = this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
        if (bodyCheckTimeout < 0) {
            this.responseBodyConsumed();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Check for non-compliant response body. Timeout in " + bodyCheckTimeout + " ms");
            }
            boolean responseAvailable = false;
            try {
                responseAvailable = conn.isResponseAvailable(bodyCheckTimeout);
            }
            catch (IOException e) {
                LOG.debug("An IOException occurred while testing if a response was available, we will assume one is not.", e);
                responseAvailable = false;
            }
            if (responseAvailable) {
                if (this.getParams().isParameterTrue("http.protocol.reject-head-body")) {
                    throw new ProtocolException("Body content may not be sent in response to HTTP HEAD request");
                }
                LOG.warn("Body content returned in response to HTTP HEAD");
                super.readResponseBody(state, conn);
            }
        }
    }

    public int getBodyCheckTimeout() {
        return this.getParams().getIntParameter("http.protocol.head-body-timeout", -1);
    }

    public void setBodyCheckTimeout(int timeout) {
        this.getParams().setIntParameter("http.protocol.head-body-timeout", timeout);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

