/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.model;

import alluxio.underfs.gcs.org.jets3t.service.model.StorageOwner;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStorageItem {
    public static final String METADATA_HEADER_CREATION_DATE = "Date";
    public static final String METADATA_HEADER_LAST_MODIFIED_DATE = "Last-Modified";
    public static final String METADATA_HEADER_DATE = "Date";
    public static final String METADATA_HEADER_CONTENT_MD5 = "Content-MD5";
    public static final String METADATA_HEADER_CONTENT_LENGTH = "Content-Length";
    public static final String METADATA_HEADER_CONTENT_TYPE = "Content-Type";
    public static final String METADATA_HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String METADATA_HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String METADATA_HEADER_CONTENT_LANGUAGE = "Content-Language";
    public static final String METADATA_HEADER_ETAG = "ETag";
    private String name = null;
    private StorageOwner owner = null;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    protected BaseStorageItem(String name) {
        this.name = name;
    }

    protected BaseStorageItem() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getMetadataMap() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public Object getMetadata(String name) {
        return this.metadata.get(name);
    }

    public boolean containsMetadata(String name) {
        return this.metadata.keySet().contains(name);
    }

    public void addMetadata(String name, String value) {
        this.metadata.put(name, value);
    }

    public void addMetadata(String name, Date value) {
        this.metadata.put(name, value);
    }

    public void addMetadata(String name, StorageOwner value) {
        this.metadata.put(name, value);
    }

    public void addAllMetadata(Map<String, Object> metadata) {
        this.metadata.putAll(metadata);
    }

    public void removeMetadata(String name) {
        this.metadata.remove(name);
    }

    public void replaceAllMetadata(Map<String, Object> metadata) {
        this.metadata.clear();
        this.addAllMetadata(metadata);
    }

    public StorageOwner getOwner() {
        return this.owner;
    }

    public void setOwner(StorageOwner owner) {
        this.owner = owner;
    }
}

