/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.multi.event;

import alluxio.underfs.gcs.org.jets3t.service.model.StorageObject;
import alluxio.underfs.gcs.org.jets3t.service.multi.ThreadWatcher;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.ServiceEvent;

public class CreateObjectsEvent
extends ServiceEvent {
    private StorageObject[] objects = null;

    private CreateObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static CreateObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static CreateObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CreateObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, StorageObject[] completedObjects, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static CreateObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static CreateObjectsEvent newCancelledEvent(StorageObject[] incompletedObjects, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static CreateObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(StorageObject[] objects) {
        this.objects = objects;
    }

    public StorageObject[] getCreatedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public StorageObject[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

