/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.multithread;

import alluxio.underfs.gcs.org.jets3t.service.model.S3Object;
import alluxio.underfs.gcs.org.jets3t.service.multithread.ServiceEvent;
import alluxio.underfs.gcs.org.jets3t.service.multithread.ThreadWatcher;

public class CreateObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private CreateObjectsEvent(int eventCode, Object uniqueOperationId) {
        super(eventCode, uniqueOperationId);
    }

    public static CreateObjectsEvent newErrorEvent(Throwable t, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(0, uniqueOperationId);
        event.setErrorCause(t);
        return event;
    }

    public static CreateObjectsEvent newStartedEvent(ThreadWatcher threadWatcher, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(1, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CreateObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(3, uniqueOperationId);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static CreateObjectsEvent newCompletedEvent(Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(2, uniqueOperationId);
        return event;
    }

    public static CreateObjectsEvent newCancelledEvent(S3Object[] incompletedObjects, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(4, uniqueOperationId);
        event.setObjects(incompletedObjects);
        return event;
    }

    public static CreateObjectsEvent newIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors, Object uniqueOperationId) {
        CreateObjectsEvent event = new CreateObjectsEvent(5, uniqueOperationId);
        event.setIgnoredErrors(ignoredErrors);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getCreatedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

