/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.underfs.gcs.org.jets3t.service.ServiceException;
import alluxio.underfs.gcs.org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import alluxio.underfs.gcs.org.jets3t.service.model.GSObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GCSInputStream
extends InputStream {
    private final String mBucketName;
    private final String mKey;
    private final GoogleStorageService mClient;
    private GSObject mObject;
    private BufferedInputStream mInputStream;
    private long mPos;

    GCSInputStream(String bucketName, String key, GoogleStorageService client) throws ServiceException {
        this(bucketName, key, client, 0L);
    }

    GCSInputStream(String bucketName, String key, GoogleStorageService client, long pos) throws ServiceException {
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mPos = pos;
        this.mObject = this.mPos > 0L ? this.mClient.getObject(this.mBucketName, this.mKey, null, null, null, null, this.mPos, null) : this.mClient.getObject(this.mBucketName, this.mKey);
        this.mInputStream = new BufferedInputStream(this.mObject.getDataInputStream());
    }

    @Override
    public void close() throws IOException {
        this.mInputStream.close();
    }

    @Override
    public int read() throws IOException {
        int ret = this.mInputStream.read();
        if (ret != -1) {
            ++this.mPos;
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.mInputStream.read(b, off, len);
        if (ret != -1) {
            this.mPos += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        if ((long)this.mInputStream.available() >= n) {
            return this.mInputStream.skip(n);
        }
        this.mInputStream.close();
        this.mPos += n;
        try {
            this.mObject = this.mClient.getObject(this.mBucketName, this.mKey, null, null, null, null, this.mPos, null);
            this.mInputStream = new BufferedInputStream(this.mObject.getDataInputStream());
        }
        catch (ServiceException e) {
            throw new IOException(e);
        }
        return n;
    }
}

