/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.io;

import alluxio.underfs.gcs.org.jets3t.service.io.BytesProgressWatcher;
import alluxio.underfs.gcs.org.jets3t.service.io.InputStreamWrapper;
import java.io.IOException;
import java.io.InputStream;

public class ProgressMonitoredInputStream
extends InputStream
implements InputStreamWrapper {
    private InputStream inputStream = null;
    private BytesProgressWatcher progressWatcher = null;

    public ProgressMonitoredInputStream(InputStream inputStream, BytesProgressWatcher progressWatcher) {
        if (inputStream == null) {
            throw new IllegalArgumentException("ProgressMonitoredInputStream cannot run with a null InputStream");
        }
        this.inputStream = inputStream;
        this.progressWatcher = progressWatcher;
    }

    public void sendNotificationUpdate(long bytesTransmitted) {
        this.progressWatcher.updateBytesTransferred(bytesTransmitted);
    }

    public void resetProgressMonitor() {
        this.progressWatcher.resetWatcher();
    }

    public int read() throws IOException {
        int read = this.inputStream.read();
        if (read != -1) {
            this.sendNotificationUpdate(1L);
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read != -1) {
            this.sendNotificationUpdate(read);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.inputStream.read(b);
        if (read != -1) {
            this.sendNotificationUpdate(read);
        }
        return read;
    }

    public int available() throws IOException {
        return this.inputStream.available();
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }
}

