/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.model.cloudfront;

import alluxio.underfs.gcs.org.jets3t.service.model.cloudfront.DistributionConfig;
import alluxio.underfs.gcs.org.jets3t.service.model.cloudfront.Origin;
import alluxio.underfs.gcs.org.jets3t.service.model.cloudfront.StreamingDistribution;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Distribution {
    private String id = null;
    private String status = null;
    private Date lastModifiedTime = null;
    private String domainName = null;
    private Map activeTrustedSigners = new HashMap();
    private Origin origin = null;
    private String[] cnames = new String[0];
    private String comment = null;
    private boolean enabled = false;
    private DistributionConfig config = null;

    public Distribution(String id, String status, Date lastModifiedDate, String domainName, Origin origin, String[] cnames, String comment, boolean enabled) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.origin = origin;
        this.cnames = cnames;
        this.comment = comment;
        this.enabled = enabled;
    }

    public Distribution(String id, String status, Date lastModifiedDate, String domainName, Map activeTrustedSigners, DistributionConfig config) {
        this.id = id;
        this.status = status;
        this.lastModifiedTime = lastModifiedDate;
        this.domainName = domainName;
        this.activeTrustedSigners = activeTrustedSigners;
        this.config = config;
    }

    public boolean isSummary() {
        return this.getConfig() == null;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Map getActiveTrustedSigners() {
        return this.activeTrustedSigners;
    }

    public String getId() {
        return this.id;
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String[] getCNAMEs() {
        return this.cnames;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isDeployed() {
        return "Deployed".equals(this.getStatus());
    }

    public DistributionConfig getConfig() {
        return this.config;
    }

    public boolean isStreamingDistribution() {
        return this instanceof StreamingDistribution;
    }

    public String toString() {
        return (this.isStreamingDistribution() ? "CloudFrontStreamingDistribution" : "CloudFrontDistribution") + ": id=" + this.id + ", status=" + this.status + ", domainName=" + this.domainName + ", activeTrustedSigners=" + this.activeTrustedSigners + ", lastModifiedTime=" + this.lastModifiedTime + (this.isSummary() ? ", origin=" + this.origin + ", comment=" + this.comment + ", enabled=" + this.enabled + ", CNAMEs=" + Arrays.asList(this.cnames) : ", config=[" + this.config + "]");
    }
}

