/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.multi;

import alluxio.underfs.gcs.org.jets3t.service.ServiceException;
import alluxio.underfs.gcs.org.jets3t.service.StorageService;
import alluxio.underfs.gcs.org.jets3t.service.model.StorageBucket;
import alluxio.underfs.gcs.org.jets3t.service.model.StorageObject;
import alluxio.underfs.gcs.org.jets3t.service.multi.DownloadPackage;
import alluxio.underfs.gcs.org.jets3t.service.multi.StorageServiceEventAdaptor;
import alluxio.underfs.gcs.org.jets3t.service.multi.ThreadedStorageService;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CopyObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CreateBucketsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CreateObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.DeleteObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.DownloadObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.GetObjectHeadsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.LookupACLEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.UpdateACLEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class SimpleThreadedStorageService {
    private StorageService service = null;

    public SimpleThreadedStorageService(StorageService service) {
        this.service = service;
    }

    protected void throwError(StorageServiceEventAdaptor adaptor) throws ServiceException {
        if (adaptor.wasErrorThrown()) {
            Throwable thrown = adaptor.getErrorThrown();
            if (thrown instanceof ServiceException) {
                throw (ServiceException)thrown;
            }
            throw new ServiceException(thrown);
        }
    }

    public StorageBucket[] createBuckets(String[] bucketNames) throws ServiceException {
        final ArrayList bucketList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CreateBucketsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    bucketList.addAll(Arrays.asList(event.getCreatedBuckets()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).createBuckets(bucketNames);
        this.throwError(adaptor);
        return bucketList.toArray(new StorageBucket[bucketList.size()]);
    }

    public StorageObject[] putObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CreateObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCreatedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).putObjects(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public Map[] copyObjects(String sourceBucketName, String destinationBucketName, String[] sourceObjectKeys, StorageObject[] destinationObjects, boolean replaceMetadata) throws ServiceException {
        final ArrayList resultsList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(CopyObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    resultsList.addAll(Arrays.asList(event.getCopyResults()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).copyObjects(sourceBucketName, destinationBucketName, sourceObjectKeys, destinationObjects, replaceMetadata);
        this.throwError(adaptor);
        return resultsList.toArray(new Map[resultsList.size()]);
    }

    public void deleteObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(DeleteObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDeletedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).deleteObjects(bucketName, objects);
        this.throwError(adaptor);
    }

    public StorageObject[] getObjects(String bucketName, StorageObject[] objects) throws ServiceException {
        DownloadPackage[] downloadPackages = new DownloadPackage[objects.length];
        try {
            for (int i = 0; i < downloadPackages.length; ++i) {
                File tempFile = File.createTempFile("jets3t-", ".tmp");
                tempFile.deleteOnExit();
                downloadPackages[i] = new DownloadPackage(objects[i], tempFile);
            }
        }
        catch (IOException e) {
            throw new ServiceException("Unable to create temporary file to store object data", e);
        }
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(DownloadObjectsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getDownloadedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).downloadObjects(bucketName, downloadPackages);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public StorageObject[] getObjects(String bucketName, String[] objectKeys) throws ServiceException {
        StorageObject[] objects = new StorageObject[objectKeys.length];
        for (int i = 0; i < objectKeys.length; ++i) {
            objects[i] = new StorageObject(objectKeys[i]);
        }
        return this.getObjects(bucketName, objects);
    }

    public StorageObject[] getObjectsHeads(String bucketName, StorageObject[] objects) throws ServiceException {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucketName, objectKeys);
    }

    public StorageObject[] getObjectsHeads(String bucketName, String[] objectKeys) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(GetObjectHeadsEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getCompletedObjects()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).getObjectsHeads(bucketName, objectKeys);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public StorageObject[] getObjectACLs(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(LookupACLEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithACL()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).getObjectACLs(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public StorageObject[] putACLs(String bucketName, StorageObject[] objects) throws ServiceException {
        final ArrayList objectList = new ArrayList();
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor(){

            public void event(UpdateACLEvent event) {
                super.event(event);
                if (3 == event.getEventCode()) {
                    objectList.addAll(Arrays.asList(event.getObjectsWithUpdatedACL()));
                }
            }
        };
        new ThreadedStorageService(this.service, adaptor).putACLs(bucketName, objects);
        this.throwError(adaptor);
        return objectList.toArray(new StorageObject[objectList.size()]);
    }

    public void downloadObjects(String bucketName, DownloadPackage[] downloadPackages) throws ServiceException {
        StorageServiceEventAdaptor adaptor = new StorageServiceEventAdaptor();
        new ThreadedStorageService(this.service, adaptor).downloadObjects(bucketName, downloadPackages);
        this.throwError(adaptor);
    }
}

