/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.multi;

import alluxio.underfs.gcs.org.apache.commons.logging.Log;
import alluxio.underfs.gcs.org.apache.commons.logging.LogFactory;
import alluxio.underfs.gcs.org.jets3t.service.Jets3tProperties;
import alluxio.underfs.gcs.org.jets3t.service.ServiceException;
import alluxio.underfs.gcs.org.jets3t.service.StorageObjectsChunk;
import alluxio.underfs.gcs.org.jets3t.service.StorageService;
import alluxio.underfs.gcs.org.jets3t.service.acl.AccessControlList;
import alluxio.underfs.gcs.org.jets3t.service.io.BytesProgressWatcher;
import alluxio.underfs.gcs.org.jets3t.service.io.InterruptableInputStream;
import alluxio.underfs.gcs.org.jets3t.service.io.ProgressMonitoredInputStream;
import alluxio.underfs.gcs.org.jets3t.service.io.TempFile;
import alluxio.underfs.gcs.org.jets3t.service.model.StorageBucket;
import alluxio.underfs.gcs.org.jets3t.service.model.StorageObject;
import alluxio.underfs.gcs.org.jets3t.service.multi.CancelEventTrigger;
import alluxio.underfs.gcs.org.jets3t.service.multi.DownloadPackage;
import alluxio.underfs.gcs.org.jets3t.service.multi.StorageServiceEventListener;
import alluxio.underfs.gcs.org.jets3t.service.multi.ThreadWatcher;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CopyObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CreateBucketsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.CreateObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.DeleteObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.DownloadObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.GetObjectHeadsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.GetObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.ListObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.LookupACLEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.ServiceEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.UpdateACLEvent;
import alluxio.underfs.gcs.org.jets3t.service.security.ProviderCredentials;
import alluxio.underfs.gcs.org.jets3t.service.utils.ServiceUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ThreadedStorageService {
    private static final Log log = LogFactory.getLog(ThreadedStorageService.class);
    protected StorageService storageService = null;
    protected final boolean[] isShutdown = new boolean[]{false};
    protected final List<StorageServiceEventListener> serviceEventListeners = new ArrayList<StorageServiceEventListener>();
    protected final long sleepTime;

    public ThreadedStorageService(StorageService service, StorageServiceEventListener listener) throws ServiceException {
        this(service, listener, 500L);
    }

    public ThreadedStorageService(StorageService service, StorageServiceEventListener listener, long threadSleepTimeMS) throws ServiceException {
        this.storageService = service;
        this.addServiceEventListener(listener);
        this.sleepTime = threadSleepTimeMS;
        int adminMaxThreadCount = this.storageService.getJetS3tProperties().getIntProperty("threaded-service.admin-max-thread-count", 20);
        int maxThreadCount = this.storageService.getJetS3tProperties().getIntProperty("threaded-service.max-thread-count", 2);
        int maxConnectionCount = this.storageService.getJetS3tProperties().getIntProperty("httpclient.max-connections", 20);
        if (maxConnectionCount < maxThreadCount) {
            throw new ServiceException("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run (threaded-service.max-thread-count=" + maxThreadCount + ") simultaneous threads - please adjust JetS3t properties");
        }
        if (maxConnectionCount < adminMaxThreadCount) {
            throw new ServiceException("Insufficient connections available (httpclient.max-connections=" + maxConnectionCount + ") to run (threaded-service.admin-max-thread-count=" + adminMaxThreadCount + ") simultaneous admin threads - please adjust JetS3t properties");
        }
    }

    public void shutdown() throws ServiceException {
        this.isShutdown[0] = true;
        this.getStorageService().shutdown();
    }

    public boolean isShutdown() {
        return this.isShutdown[0];
    }

    public StorageService getStorageService() {
        return this.storageService;
    }

    public void addServiceEventListener(StorageServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.add(listener);
        }
    }

    public void removeServiceEventListener(StorageServiceEventListener listener) {
        if (listener != null) {
            this.serviceEventListeners.remove(listener);
        }
    }

    protected void fireServiceEvent(ServiceEvent event) {
        if (this.serviceEventListeners.size() == 0 && log.isWarnEnabled()) {
            log.warn("ThreadedStorageService invoked without any StorageServiceEventListener objects, this is dangerous!");
        }
        for (StorageServiceEventListener listener : this.serviceEventListeners) {
            if (event instanceof CreateObjectsEvent) {
                listener.event((CreateObjectsEvent)event);
                continue;
            }
            if (event instanceof CopyObjectsEvent) {
                listener.event((CopyObjectsEvent)event);
                continue;
            }
            if (event instanceof CreateBucketsEvent) {
                listener.event((CreateBucketsEvent)event);
                continue;
            }
            if (event instanceof ListObjectsEvent) {
                listener.event((ListObjectsEvent)event);
                continue;
            }
            if (event instanceof DeleteObjectsEvent) {
                listener.event((DeleteObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectsEvent) {
                listener.event((GetObjectsEvent)event);
                continue;
            }
            if (event instanceof GetObjectHeadsEvent) {
                listener.event((GetObjectHeadsEvent)event);
                continue;
            }
            if (event instanceof LookupACLEvent) {
                listener.event((LookupACLEvent)event);
                continue;
            }
            if (event instanceof UpdateACLEvent) {
                listener.event((UpdateACLEvent)event);
                continue;
            }
            if (event instanceof DownloadObjectsEvent) {
                listener.event((DownloadObjectsEvent)event);
                continue;
            }
            throw new IllegalArgumentException("Listener not invoked for event class: " + event.getClass());
        }
    }

    public boolean isAuthenticatedConnection() {
        return this.storageService.isAuthenticatedConnection();
    }

    public ProviderCredentials getProviderCredentials() {
        return this.storageService.getProviderCredentials();
    }

    public boolean listObjects(String bucketName, String[] prefixes, String delimiter, long maxListingLength) {
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new ListObjectsRunnable[prefixes.length];
        for (int i = 0; i < runnables.length; ++i) {
            runnables[i] = new ListObjectsRunnable(bucketName, prefixes[i], delimiter, maxListingLength, null);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List chunkList) {
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newInProgressEvent(threadWatcher, chunkList, uniqueOperationId));
            }

            public void fireCancelEvent() {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newCancelledEvent(uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(ListObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean createBuckets(String[] bucketNames) {
        final ArrayList<String> incompletedBucketList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CreateBucketRunnable[bucketNames.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedBucketList.add(bucketNames[i]);
            runnables[i] = new CreateBucketRunnable(bucketNames[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedBucketList.removeAll(completedResults);
                StorageBucket[] completedBuckets = completedResults.toArray(new StorageBucket[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newInProgressEvent(threadWatcher, completedBuckets, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageBucket[] incompletedBuckets = incompletedBucketList.toArray(new StorageBucket[incompletedBucketList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newCancelledEvent(incompletedBuckets, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateBucketsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean copyObjects(String sourceBucketName, String destinationBucketName, final String[] sourceObjectKeys, final StorageObject[] destinationObjects, boolean replaceMetadata) {
        final ArrayList<StorageObject> incompletedObjectsList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CopyObjectRunnable[sourceObjectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(destinationObjects[i]);
            runnables[i] = new CopyObjectRunnable(sourceBucketName, destinationBucketName, sourceObjectKeys[i], destinationObjects[i], replaceMetadata);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                Map[] copyResults = completedResults.toArray(new Map[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newInProgressEvent(threadWatcher, copyResults, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] incompletedObjects = incompletedObjectsList.toArray(new StorageObject[incompletedObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newCompletedEvent(uniqueOperationId, sourceObjectKeys, destinationObjects));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CopyObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putObjects(String bucketName, StorageObject[] objects) {
        final ArrayList<StorageObject> incompletedObjectsList = new ArrayList<StorageObject>();
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new CreateObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            incompletedObjectsList.add(objects[i]);
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            runnables[i] = new CreateObjectRunnable(bucketName, objects[i], progressMonitor);
            progressWatchers.add(progressMonitor);
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, threadWatcher, this.storageService.getJetS3tProperties(), false){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompletedObjectsList.removeAll(completedResults);
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] incompletedObjects = incompletedObjectsList.toArray(new StorageObject[incompletedObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newCancelledEvent(incompletedObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(CreateObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean deleteObjects(String bucketName, String[] objectKeys) {
        StorageObject[] objects = new StorageObject[objectKeys.length];
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = new StorageObject(objectKeys[i]);
        }
        return this.deleteObjects(bucketName, objects);
    }

    public boolean deleteObjects(String bucketName, StorageObject[] objects) {
        final ArrayList<StorageObject> objectsToDeleteList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new DeleteObjectRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            objectsToDeleteList.add(objects[i]);
            runnables[i] = new DeleteObjectRunnable(bucketName, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                objectsToDeleteList.removeAll(completedResults);
                StorageObject[] deletedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newInProgressEvent(threadWatcher, deletedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] remainingObjects = objectsToDeleteList.toArray(new StorageObject[objectsToDeleteList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newCancelledEvent(remainingObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DeleteObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjects(String bucketName, StorageObject[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjects(bucketName, objectKeys);
    }

    public boolean getObjects(String bucketName, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucketName, objectKeys[i], false);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), false){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<StorageObject> cancelledObjectsList = new ArrayList<StorageObject>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new StorageObject(key));
                }
                StorageObject[] cancelledObjects = cancelledObjectsList.toArray(new StorageObject[cancelledObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectsHeads(String bucketName, StorageObject[] objects) {
        String[] objectKeys = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            objectKeys[i] = objects[i].getKey();
        }
        return this.getObjectsHeads(bucketName, objectKeys);
    }

    public boolean getObjectsHeads(String bucketName, String[] objectKeys) {
        final ArrayList<String> pendingObjectKeysList = new ArrayList<String>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetObjectRunnable[objectKeys.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectKeysList.add(objectKeys[i]);
            runnables[i] = new GetObjectRunnable(bucketName, objectKeys[i], true);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                for (int i = 0; i < completedObjects.length; ++i) {
                    pendingObjectKeysList.remove(completedObjects[i].getKey());
                }
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                ArrayList<StorageObject> cancelledObjectsList = new ArrayList<StorageObject>();
                for (String key : pendingObjectKeysList) {
                    cancelledObjectsList.add(new StorageObject(key));
                }
                StorageObject[] cancelledObjects = cancelledObjectsList.toArray(new StorageObject[cancelledObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(GetObjectHeadsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean getObjectACLs(String bucketName, StorageObject[] objects) {
        final ArrayList<StorageObject> pendingObjectsList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new GetACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new GetACLRunnable(bucketName, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] cancelledObjects = pendingObjectsList.toArray(new StorageObject[pendingObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(LookupACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean putACLs(String bucketName, StorageObject[] objects) {
        final ArrayList<StorageObject> pendingObjectsList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        AbstractRunnable[] runnables = new PutACLRunnable[objects.length];
        for (int i = 0; i < runnables.length; ++i) {
            pendingObjectsList.add(objects[i]);
            runnables[i] = new PutACLRunnable(bucketName, objects[i]);
        }
        new ThreadGroupManager(runnables, new ThreadWatcher(runnables.length), this.storageService.getJetS3tProperties(), true){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                pendingObjectsList.removeAll(completedResults);
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] cancelledObjects = pendingObjectsList.toArray(new StorageObject[pendingObjectsList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newCancelledEvent(cancelledObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(UpdateACLEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    public boolean downloadObjects(String bucketName, DownloadPackage[] downloadPackages) throws ServiceException {
        ArrayList<BytesProgressWatcher> progressWatchers = new ArrayList<BytesProgressWatcher>();
        final ArrayList<StorageObject> incompleteObjectDownloadList = new ArrayList<StorageObject>();
        final Object uniqueOperationId = new Object();
        final boolean[] success = new boolean[]{true};
        boolean restoreLastModifiedDate = this.storageService.getJetS3tProperties().getBoolProperty("downloads.restoreLastModifiedDate", false);
        AbstractRunnable[] runnables = new DownloadObjectRunnable[downloadPackages.length];
        StorageObject[] objects = new StorageObject[downloadPackages.length];
        for (int i = 0; i < runnables.length; ++i) {
            objects[i] = downloadPackages[i].getObject();
            BytesProgressWatcher progressMonitor = new BytesProgressWatcher(objects[i].getContentLength());
            incompleteObjectDownloadList.add(objects[i]);
            progressWatchers.add(progressMonitor);
            runnables[i] = new DownloadObjectRunnable(bucketName, objects[i].getKey(), downloadPackages[i], progressMonitor, restoreLastModifiedDate);
        }
        ThreadWatcher threadWatcher = new ThreadWatcher(progressWatchers.toArray(new BytesProgressWatcher[progressWatchers.size()]));
        new ThreadGroupManager(runnables, threadWatcher, this.storageService.getJetS3tProperties(), false){

            public void fireStartEvent(ThreadWatcher threadWatcher) {
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newStartedEvent(threadWatcher, uniqueOperationId));
            }

            public void fireProgressEvent(ThreadWatcher threadWatcher, List completedResults) {
                incompleteObjectDownloadList.removeAll(completedResults);
                StorageObject[] completedObjects = completedResults.toArray(new StorageObject[completedResults.size()]);
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newInProgressEvent(threadWatcher, completedObjects, uniqueOperationId));
            }

            public void fireCancelEvent() {
                StorageObject[] incompleteObjects = incompleteObjectDownloadList.toArray(new StorageObject[incompleteObjectDownloadList.size()]);
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newCancelledEvent(incompleteObjects, uniqueOperationId));
            }

            public void fireCompletedEvent() {
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newCompletedEvent(uniqueOperationId));
            }

            public void fireErrorEvent(Throwable throwable) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newErrorEvent(throwable, uniqueOperationId));
            }

            public void fireIgnoredErrorsEvent(ThreadWatcher threadWatcher, Throwable[] ignoredErrors) {
                success[0] = false;
                ThreadedStorageService.this.fireServiceEvent(DownloadObjectsEvent.newIgnoredErrorsEvent(threadWatcher, ignoredErrors, uniqueOperationId));
            }
        }.run();
        return success[0];
    }

    protected abstract class ThreadGroupManager {
        private final Log log = LogFactory.getLog(ThreadGroupManager.class);
        private int maxThreadCount = 1;
        private AbstractRunnable[] runnables = null;
        private Thread[] threads = null;
        private boolean ignoreExceptions = false;
        private boolean[] started = null;
        private boolean[] alreadyFired = null;
        private ThreadWatcher threadWatcher = null;
        private long lastProgressEventFiredTime = 0L;

        public ThreadGroupManager(AbstractRunnable[] runnables, ThreadWatcher threadWatcher, Jets3tProperties jets3tProperties, boolean isAdminTask) {
            this.runnables = runnables;
            this.threadWatcher = threadWatcher;
            this.maxThreadCount = isAdminTask ? jets3tProperties.getIntProperty("threaded-service.admin-max-thread-count", 20) : jets3tProperties.getIntProperty("threaded-service.max-thread-count", 2);
            this.ignoreExceptions = jets3tProperties.getBoolProperty("threaded-service.ignore-exceptions-in-multi", false);
            this.threads = new Thread[runnables.length];
            this.started = new boolean[runnables.length];
            this.alreadyFired = new boolean[runnables.length];
        }

        private ResultsTuple getNewlyCompletedResults() throws Throwable {
            ArrayList<Object> completedResults = new ArrayList<Object>();
            ArrayList<Throwable> errorResults = new ArrayList<Throwable>();
            for (int i = 0; i < this.threads.length; ++i) {
                if (this.alreadyFired[i] || !this.started[i] || this.threads[i].isAlive()) continue;
                this.alreadyFired[i] = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Thread " + (i + 1) + " of " + this.threads.length + " has recently completed, releasing resources");
                }
                if (this.runnables[i].getResult() instanceof Throwable) {
                    Throwable throwable = (Throwable)this.runnables[i].getResult();
                    this.runnables[i] = null;
                    this.threads[i] = null;
                    if (this.ignoreExceptions) {
                        if (this.log.isWarnEnabled()) {
                            this.log.warn("Ignoring exception (property threaded-service.ignore-exceptions-in-multi is set to true)", throwable);
                        }
                        errorResults.add(throwable);
                        continue;
                    }
                    throw throwable;
                }
                completedResults.add(this.runnables[i].getResult());
                this.runnables[i] = null;
                this.threads[i] = null;
            }
            Throwable[] ignoredErrors = new Throwable[]{};
            if (errorResults.size() > 0) {
                ignoredErrors = errorResults.toArray(new Throwable[errorResults.size()]);
            }
            return new ResultsTuple(completedResults, ignoredErrors);
        }

        private void startPendingThreads() throws Throwable {
            int i;
            int runningThreadCount = 0;
            for (i = 0; i < this.runnables.length; ++i) {
                if (!this.started[i] || this.alreadyFired[i]) continue;
                ++runningThreadCount;
            }
            for (i = 0; runningThreadCount < this.maxThreadCount && i < this.started.length; ++i) {
                if (this.started[i]) continue;
                this.threads[i] = new Thread(this.runnables[i]);
                this.threads[i].start();
                this.started[i] = true;
                ++runningThreadCount;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Thread " + (i + 1) + " of " + this.runnables.length + " has started");
            }
        }

        private int getPendingThreadCount() {
            int pendingThreadCount = 0;
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.alreadyFired[i]) continue;
                ++pendingThreadCount;
            }
            return pendingThreadCount;
        }

        private void forceInterruptAllRunnables() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Setting force interrupt flag on all runnables");
            }
            for (int i = 0; i < this.runnables.length; ++i) {
                if (this.runnables[i] == null) continue;
                this.runnables[i].forceInterrupt();
                this.runnables[i] = null;
            }
        }

        public void run() {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Started ThreadManager");
            }
            final boolean[] interrupted = new boolean[]{false};
            CancelEventTrigger cancelEventTrigger = new CancelEventTrigger(){
                private static final long serialVersionUID = 6328417466929608235L;

                public void cancelTask(Object eventSource) {
                    if (ThreadGroupManager.this.log.isDebugEnabled()) {
                        ThreadGroupManager.this.log.debug("Cancel task invoked on ThreadManager");
                    }
                    interrupted[0] = true;
                    ThreadGroupManager.this.forceInterruptAllRunnables();
                }
            };
            try {
                ResultsTuple results;
                int completedThreads;
                this.startPendingThreads();
                this.threadWatcher.updateThreadsCompletedCount(0L, cancelEventTrigger);
                this.fireStartEvent(this.threadWatcher);
                while (!interrupted[0] && this.getPendingThreadCount() > 0) {
                    try {
                        if (ThreadedStorageService.this.isShutdown[0]) {
                            throw new InterruptedException("StorageServiceMulti#shutdown method invoked");
                        }
                        Thread.sleep(100L);
                        if (interrupted[0]) continue;
                        if (System.currentTimeMillis() - this.lastProgressEventFiredTime > ThreadedStorageService.this.sleepTime) {
                            completedThreads = this.runnables.length - this.getPendingThreadCount();
                            this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                            results = this.getNewlyCompletedResults();
                            this.lastProgressEventFiredTime = System.currentTimeMillis();
                            this.fireProgressEvent(this.threadWatcher, results.completedResults);
                            if (results.errorResults.length > 0) {
                                this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                            }
                        }
                        this.startPendingThreads();
                    }
                    catch (InterruptedException e) {
                        interrupted[0] = true;
                        this.forceInterruptAllRunnables();
                    }
                }
                if (interrupted[0]) {
                    this.fireCancelEvent();
                } else {
                    completedThreads = this.runnables.length - this.getPendingThreadCount();
                    this.threadWatcher.updateThreadsCompletedCount(completedThreads, cancelEventTrigger);
                    results = this.getNewlyCompletedResults();
                    this.fireProgressEvent(this.threadWatcher, results.completedResults);
                    if (results.completedResults.size() > 0 && this.log.isDebugEnabled()) {
                        this.log.debug(results.completedResults.size() + " threads have recently completed");
                    }
                    if (results.errorResults.length > 0) {
                        this.fireIgnoredErrorsEvent(this.threadWatcher, results.errorResults);
                    }
                    this.fireCompletedEvent();
                }
            }
            catch (Throwable t) {
                if (this.log.isErrorEnabled()) {
                    this.log.error("A thread failed with an exception. Firing ERROR event and cancelling all threads", t);
                }
                this.forceInterruptAllRunnables();
                this.fireErrorEvent(t);
            }
        }

        public abstract void fireStartEvent(ThreadWatcher var1);

        public abstract void fireProgressEvent(ThreadWatcher var1, List var2);

        public abstract void fireCompletedEvent();

        public abstract void fireCancelEvent();

        public abstract void fireErrorEvent(Throwable var1);

        public abstract void fireIgnoredErrorsEvent(ThreadWatcher var1, Throwable[] var2);

        private class ResultsTuple {
            public List completedResults = null;
            public Throwable[] errorResults = null;

            public ResultsTuple(List completedResults, Throwable[] errorResults) {
                this.completedResults = completedResults;
                this.errorResults = errorResults;
            }
        }
    }

    private class DownloadObjectRunnable
    extends AbstractRunnable {
        private String objectKey;
        private String bucketName;
        private DownloadPackage downloadPackage;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private boolean restoreLastModifiedDate;
        private Object result;

        public DownloadObjectRunnable(String bucketName, String objectKey, DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucketName = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.bucketName = bucketName;
            this.objectKey = objectKey;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        public DownloadObjectRunnable(DownloadPackage downloadPackage, BytesProgressWatcher progressMonitor, boolean restoreLastModifiedDate) {
            this.objectKey = null;
            this.bucketName = null;
            this.downloadPackage = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.restoreLastModifiedDate = true;
            this.result = null;
            this.downloadPackage = downloadPackage;
            this.progressMonitor = progressMonitor;
            this.restoreLastModifiedDate = restoreLastModifiedDate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream bufferedOutputStream = null;
            StorageObject object = null;
            try {
                String metadataLocalFileDate;
                MessageDigest messageDigest;
                block35: {
                    object = ThreadedStorageService.this.storageService.getObject(this.bucketName, this.objectKey);
                    this.downloadPackage.setObject(object);
                    this.interruptableInputStream = new InterruptableInputStream(object.getDataInputStream());
                    bufferedInputStream = new BufferedInputStream(new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor));
                    bufferedOutputStream = new BufferedOutputStream(this.downloadPackage.getOutputStream());
                    messageDigest = null;
                    try {
                        messageDigest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        if (!log.isWarnEnabled()) break block35;
                        log.warn("Unable to calculate MD5 hash of data received as algorithm is not available", e);
                    }
                }
                try {
                    byte[] buffer = new byte[1024];
                    int byteCount = -1;
                    while ((byteCount = bufferedInputStream.read(buffer)) != -1) {
                        ((BufferedOutputStream)bufferedOutputStream).write(buffer, 0, byteCount);
                        if (messageDigest == null) continue;
                        messageDigest.update(buffer, 0, byteCount);
                    }
                    if (messageDigest != null) {
                        byte[] dataMD5Hash = messageDigest.digest();
                        String hexMD5OfDownloadedData = ServiceUtils.toHex(dataMD5Hash);
                        if (!ServiceUtils.isEtagAlsoAnMD5Hash(object.getETag())) {
                            if (!hexMD5OfDownloadedData.equals(object.getMd5HashAsHex()) && log.isWarnEnabled()) {
                                log.warn("Unable to verify MD5 hash of downloaded data against ETag returned by service because ETag value \"" + object.getETag() + "\" is not an MD5 hash value" + ", for object key: " + object.getKey());
                            }
                        } else {
                            if (!hexMD5OfDownloadedData.equals(object.getETag())) {
                                throw new ServiceException("Mismatch between MD5 hash of downloaded data (" + hexMD5OfDownloadedData + ") and ETag returned by service (" + object.getETag() + ") for object key: " + object.getKey());
                            }
                            if (log.isDebugEnabled()) {
                                log.debug("Object download was automatically verified, the calculated MD5 hash value matched the ETag provided by service: " + object.getKey());
                            }
                        }
                    }
                }
                finally {
                    if (bufferedOutputStream != null) {
                        bufferedOutputStream.close();
                    }
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                object.setDataInputStream(null);
                object.setDataInputFile(this.downloadPackage.getDataFile());
                if (this.restoreLastModifiedDate && this.downloadPackage.getDataFile() != null && (metadataLocalFileDate = (String)object.getMetadata("jets3t-original-file-date-iso8601")) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Restoring original Last Modified date for object '" + object.getKey() + "' to file '" + this.downloadPackage.getDataFile() + "': " + metadataLocalFileDate);
                    }
                    this.downloadPackage.getDataFile().setLastModified(ServiceUtils.parseIso8601Date(metadataLocalFileDate).getTime());
                }
                this.result = object;
            }
            catch (Throwable t) {
                this.result = t;
            }
            finally {
                block39: {
                    block38: {
                        if (bufferedInputStream != null) {
                            try {
                                bufferedInputStream.close();
                            }
                            catch (Exception e) {
                                if (!log.isErrorEnabled()) break block38;
                                log.error("Unable to close Object input stream", e);
                            }
                        }
                    }
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (Exception e) {
                            if (!log.isErrorEnabled()) break block39;
                            log.error("Unable to close download output stream", e);
                        }
                    }
                }
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class GetObjectRunnable
    extends AbstractRunnable {
        private String bucketName;
        private String objectKey;
        private boolean headOnly;
        private Object result;

        public GetObjectRunnable(String bucketName, String objectKey, boolean headOnly) {
            this.bucketName = null;
            this.objectKey = null;
            this.headOnly = false;
            this.result = null;
            this.bucketName = bucketName;
            this.objectKey = objectKey;
            this.headOnly = headOnly;
        }

        public void run() {
            try {
                this.result = this.headOnly ? ThreadedStorageService.this.storageService.getObjectDetails(this.bucketName, this.objectKey) : ThreadedStorageService.this.storageService.getObject(this.bucketName, this.objectKey);
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CopyObjectRunnable
    extends AbstractRunnable {
        private String sourceBucketName;
        private String destinationBucketName;
        private String sourceObjectKey;
        private StorageObject destinationObject;
        private boolean replaceMetadata;
        private Object result;

        public CopyObjectRunnable(String sourceBucketName, String destinationBucketName, String sourceObjectKey, StorageObject destinationObject, boolean replaceMetadata) {
            this.sourceBucketName = null;
            this.destinationBucketName = null;
            this.sourceObjectKey = null;
            this.destinationObject = null;
            this.replaceMetadata = false;
            this.result = null;
            this.sourceBucketName = sourceBucketName;
            this.destinationBucketName = destinationBucketName;
            this.sourceObjectKey = sourceObjectKey;
            this.destinationObject = destinationObject;
            this.replaceMetadata = replaceMetadata;
        }

        public void run() {
            try {
                this.result = ThreadedStorageService.this.storageService.copyObject(this.sourceBucketName, this.sourceObjectKey, this.destinationBucketName, this.destinationObject, this.replaceMetadata);
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class CreateObjectRunnable
    extends AbstractRunnable {
        private String bucketName;
        private StorageObject object;
        private InterruptableInputStream interruptableInputStream;
        private BytesProgressWatcher progressMonitor;
        private Object result;

        public CreateObjectRunnable(String bucketName, StorageObject object, BytesProgressWatcher progressMonitor) {
            this.bucketName = null;
            this.object = null;
            this.interruptableInputStream = null;
            this.progressMonitor = null;
            this.result = null;
            this.bucketName = bucketName;
            this.object = object;
            this.progressMonitor = progressMonitor;
        }

        public void run() {
            try {
                File underlyingFile = this.object.getDataInputFile();
                if (this.object.getDataInputStream() != null) {
                    this.interruptableInputStream = new InterruptableInputStream(this.object.getDataInputStream());
                    ProgressMonitoredInputStream pmInputStream = new ProgressMonitoredInputStream(this.interruptableInputStream, this.progressMonitor);
                    this.object.setDataInputStream(pmInputStream);
                }
                this.result = ThreadedStorageService.this.storageService.putObject(this.bucketName, this.object);
                if (underlyingFile instanceof TempFile) {
                    underlyingFile.delete();
                }
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            if (this.interruptableInputStream != null) {
                this.interruptableInputStream.interrupt();
            }
        }
    }

    private class ListObjectsRunnable
    extends AbstractRunnable {
        private Object result;
        private String bucketName;
        private String prefix;
        private String delimiter;
        private long maxListingLength;
        private String priorLastKey;
        private boolean halted;

        public ListObjectsRunnable(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) {
            this.result = null;
            this.bucketName = null;
            this.prefix = null;
            this.delimiter = null;
            this.maxListingLength = 1000L;
            this.priorLastKey = null;
            this.halted = false;
            this.bucketName = bucketName;
            this.prefix = prefix;
            this.delimiter = delimiter;
            this.maxListingLength = maxListingLength;
            this.priorLastKey = priorLastKey;
        }

        public void run() {
            try {
                ArrayList<StorageObject> allObjects = new ArrayList<StorageObject>();
                ArrayList<String> allCommonPrefixes = new ArrayList<String>();
                do {
                    StorageObjectsChunk chunk = ThreadedStorageService.this.storageService.listObjectsChunked(this.bucketName, this.prefix, this.delimiter, this.maxListingLength, this.priorLastKey);
                    this.priorLastKey = chunk.getPriorLastKey();
                    allObjects.addAll(Arrays.asList(chunk.getObjects()));
                    allCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                } while (!this.halted && this.priorLastKey != null);
                this.result = new StorageObjectsChunk(this.prefix, this.delimiter, allObjects.toArray(new StorageObject[allObjects.size()]), allCommonPrefixes.toArray(new String[allCommonPrefixes.size()]), null);
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
            this.halted = true;
        }
    }

    private class CreateBucketRunnable
    extends AbstractRunnable {
        private String bucketName;
        private Object result;

        public CreateBucketRunnable(String bucketName) {
            this.bucketName = null;
            this.result = null;
            this.bucketName = bucketName;
        }

        public void run() {
            try {
                this.result = ThreadedStorageService.this.storageService.createBucket(this.bucketName);
            }
            catch (ServiceException e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class DeleteObjectRunnable
    extends AbstractRunnable {
        private String bucketName;
        private StorageObject object;
        private Object result;

        public DeleteObjectRunnable(String bucketName, StorageObject object) {
            this.bucketName = null;
            this.object = null;
            this.result = null;
            this.bucketName = bucketName;
            this.object = object;
        }

        public void run() {
            try {
                ThreadedStorageService.this.storageService.deleteObject(this.bucketName, this.object.getKey());
                this.result = this.object;
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class GetACLRunnable
    extends AbstractRunnable {
        private String bucketName;
        private StorageObject object;
        private Object result;

        public GetACLRunnable(String bucketName, StorageObject object) {
            this.bucketName = null;
            this.object = null;
            this.result = null;
            this.bucketName = bucketName;
            this.object = object;
        }

        public void run() {
            try {
                AccessControlList acl = ThreadedStorageService.this.storageService.getObjectAcl(this.bucketName, this.object.getKey());
                this.object.setAcl(acl);
                this.result = this.object;
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    private class PutACLRunnable
    extends AbstractRunnable {
        private StorageBucket bucket;
        private String bucketName;
        private StorageObject object;
        private Object result;

        public PutACLRunnable(StorageBucket bucket) {
            this.bucket = null;
            this.bucketName = null;
            this.object = null;
            this.result = null;
            this.bucket = bucket;
        }

        public PutACLRunnable(String bucketName, StorageObject object) {
            this.bucket = null;
            this.bucketName = null;
            this.object = null;
            this.result = null;
            this.bucketName = bucketName;
            this.object = object;
        }

        public void run() {
            try {
                if (this.object == null) {
                    ThreadedStorageService.this.storageService.putBucketAcl(this.bucket);
                    this.result = this.bucket;
                } else {
                    ThreadedStorageService.this.storageService.putObjectAcl(this.bucketName, this.object);
                    this.result = this.object;
                }
            }
            catch (RuntimeException e) {
                this.result = e;
                throw e;
            }
            catch (Exception e) {
                this.result = e;
            }
        }

        public Object getResult() {
            return this.result;
        }

        public void forceInterruptCalled() {
        }
    }

    protected abstract class AbstractRunnable
    implements Runnable {
        protected AbstractRunnable() {
        }

        public abstract Object getResult();

        public abstract void forceInterruptCalled();

        protected void forceInterrupt() {
            this.forceInterruptCalled();
        }
    }
}

