/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.org.jets3t.service.utils;

import alluxio.underfs.gcs.org.apache.commons.logging.Log;
import alluxio.underfs.gcs.org.apache.commons.logging.LogFactory;
import alluxio.underfs.gcs.org.jets3t.service.Constants;
import alluxio.underfs.gcs.org.jets3t.service.Jets3tProperties;
import alluxio.underfs.gcs.org.jets3t.service.ServiceException;
import alluxio.underfs.gcs.org.jets3t.service.StorageObjectsChunk;
import alluxio.underfs.gcs.org.jets3t.service.StorageService;
import alluxio.underfs.gcs.org.jets3t.service.io.BytesProgressWatcher;
import alluxio.underfs.gcs.org.jets3t.service.io.ProgressMonitoredInputStream;
import alluxio.underfs.gcs.org.jets3t.service.model.StorageObject;
import alluxio.underfs.gcs.org.jets3t.service.multi.StorageServiceEventAdaptor;
import alluxio.underfs.gcs.org.jets3t.service.multi.StorageServiceEventListener;
import alluxio.underfs.gcs.org.jets3t.service.multi.ThreadedStorageService;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.GetObjectHeadsEvent;
import alluxio.underfs.gcs.org.jets3t.service.multi.event.ListObjectsEvent;
import alluxio.underfs.gcs.org.jets3t.service.utils.FileComparerResults;
import alluxio.underfs.gcs.org.jets3t.service.utils.ServiceUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.text.Normalizer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileComparer {
    private static final Log log = LogFactory.getLog(FileComparer.class);
    private Jets3tProperties jets3tProperties = null;

    public FileComparer(Jets3tProperties jets3tProperties) {
        this.jets3tProperties = jets3tProperties;
    }

    public static FileComparer getInstance(Jets3tProperties jets3tProperties) {
        return new FileComparer(jets3tProperties);
    }

    public static FileComparer getInstance() {
        return new FileComparer(Jets3tProperties.getInstance(Constants.JETS3T_PROPERTIES_FILENAME));
    }

    protected List<Pattern> buildIgnoreRegexpList(File directory, List<Pattern> parentIgnorePatternList) {
        ArrayList<Pattern> ignorePatternList;
        block12: {
            ignorePatternList = new ArrayList<Pattern>();
            if (parentIgnorePatternList != null) {
                for (Pattern parentPattern : parentIgnorePatternList) {
                    String parentIgnorePatternString = parentPattern.pattern();
                    int slashOffset = parentIgnorePatternString.indexOf(Constants.FILE_PATH_DELIM);
                    if (slashOffset < 0 || parentIgnorePatternString.length() <= slashOffset + 1) continue;
                    String patternHeader = parentIgnorePatternString.substring(0, slashOffset);
                    String patternTail = parentIgnorePatternString.substring(slashOffset + 1);
                    if (".*.*".equals(patternHeader)) {
                        ignorePatternList.add(Pattern.compile(patternTail));
                        ignorePatternList.add(parentPattern);
                        continue;
                    }
                    if (!Pattern.compile(patternHeader).matcher(directory.getName()).matches()) continue;
                    ignorePatternList.add(Pattern.compile(patternTail));
                }
            }
            if (directory == null || !directory.isDirectory()) {
                return ignorePatternList;
            }
            File jets3tIgnoreFile = new File(directory, Constants.JETS3T_IGNORE_FILENAME);
            if (jets3tIgnoreFile.exists() && jets3tIgnoreFile.canRead()) {
                if (log.isDebugEnabled()) {
                    log.debug("Found ignore file: " + jets3tIgnoreFile.getPath());
                }
                try {
                    String ignorePaths = ServiceUtils.readInputStreamToString(new FileInputStream(jets3tIgnoreFile), null);
                    StringTokenizer st = new StringTokenizer(ignorePaths.trim(), "\n");
                    while (st.hasMoreTokens()) {
                        String ignorePath;
                        String ignoreRegexp = ignorePath = st.nextToken();
                        ignoreRegexp = ignoreRegexp.replaceAll("\\.", "\\\\.");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\*", ".*");
                        ignoreRegexp = ignoreRegexp.replaceAll("\\?", ".");
                        Pattern pattern = Pattern.compile(ignoreRegexp);
                        if (log.isDebugEnabled()) {
                            log.debug("Ignore path '" + ignorePath + "' has become the regexp: " + pattern.pattern());
                        }
                        ignorePatternList.add(pattern);
                        if (!pattern.pattern().startsWith(".*.*/") || pattern.pattern().length() <= 5) continue;
                        ignorePatternList.add(Pattern.compile(pattern.pattern().substring(5)));
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) break block12;
                    log.error("Failed to read contents of ignore file '" + jets3tIgnoreFile.getPath() + "'", e);
                }
            }
        }
        if (this.isSkipMd5FileUpload()) {
            Pattern pattern = Pattern.compile(".*\\.md5");
            if (log.isDebugEnabled()) {
                log.debug("Skipping upload of pre-computed MD5 files with path '*.md5' using the regexp: " + pattern.pattern());
            }
            ignorePatternList.add(pattern);
        }
        return ignorePatternList;
    }

    protected boolean isIgnored(List<Pattern> ignorePatternList, File file) {
        if (this.isSkipSymlinks()) {
            try {
                if (!file.getAbsolutePath().equals(file.getCanonicalPath())) {
                    if (log.isDebugEnabled()) {
                        log.debug("Ignoring symlink " + (file.isDirectory() ? "directory" : "file") + ": " + file.getPath());
                    }
                    return true;
                }
            }
            catch (IOException e) {
                log.warn("Unable to determine whether " + (file.isDirectory() ? "directory" : "file") + " '" + file.getAbsolutePath() + "' is a symlink", e);
            }
        }
        if (!file.isFile() && !file.isDirectory()) {
            if (log.isDebugEnabled()) {
                log.debug("Ignoring special file: " + file.getPath());
            }
            return true;
        }
        for (Pattern pattern : ignorePatternList) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            if (log.isDebugEnabled()) {
                log.debug("Ignoring " + (file.isDirectory() ? "directory" : "file") + " matching pattern '" + pattern.pattern() + "': " + file.getPath());
            }
            return true;
        }
        return false;
    }

    protected String normalizeUnicode(String str) {
        Normalizer.Form form = Normalizer.Form.NFD;
        if (!Normalizer.isNormalized(str, form)) {
            return Normalizer.normalize(str, form);
        }
        return str;
    }

    public Map<String, String> buildObjectKeyToFilepathMap(File[] fileList, String fileKeyPrefix, boolean includeDirectories) {
        if (fileKeyPrefix == null || fileKeyPrefix.trim().length() == 0) {
            fileKeyPrefix = "";
        }
        TreeMap<String, String> objectKeyToFilepathMap = new TreeMap<String, String>();
        List<Pattern> ignorePatternList = null;
        List<Pattern> ignorePatternListForCurrentDir = null;
        for (File file : fileList) {
            if (file.getParentFile() == null) {
                if (ignorePatternListForCurrentDir == null) {
                    ignorePatternListForCurrentDir = this.buildIgnoreRegexpList(new File("."), null);
                }
                ignorePatternList = ignorePatternListForCurrentDir;
            } else {
                ignorePatternList = this.buildIgnoreRegexpList(file.getParentFile(), null);
            }
            if (this.isIgnored(ignorePatternList, file) || !file.exists()) continue;
            String objectKeyName = this.normalizeUnicode(file.getName());
            if (!file.isDirectory()) {
                objectKeyToFilepathMap.put(objectKeyName, file.getAbsolutePath());
                continue;
            }
            objectKeyName = objectKeyName + Constants.FILE_PATH_DELIM;
            if (includeDirectories) {
                objectKeyToFilepathMap.put(objectKeyName, file.getAbsolutePath());
            }
            this.buildObjectKeyToFilepathMapForDirectory(file, objectKeyName, objectKeyToFilepathMap, includeDirectories, ignorePatternList);
        }
        return objectKeyToFilepathMap;
    }

    protected void buildObjectKeyToFilepathMapForDirectory(File directory, String fileKeyPrefix, Map<String, String> objectKeyToFilepathMap, boolean includeDirectories, List<Pattern> parentIgnorePatternList) {
        List<Pattern> ignorePatternList = this.buildIgnoreRegexpList(directory, parentIgnorePatternList);
        for (File childFile : directory.listFiles()) {
            if (this.isIgnored(ignorePatternList, childFile)) continue;
            String objectKeyName = this.normalizeUnicode(fileKeyPrefix + childFile.getName());
            if (!childFile.isDirectory()) {
                objectKeyToFilepathMap.put(objectKeyName, childFile.getAbsolutePath());
                continue;
            }
            objectKeyName = objectKeyName + Constants.FILE_PATH_DELIM;
            if (includeDirectories) {
                objectKeyToFilepathMap.put(objectKeyName, childFile.getAbsolutePath());
            }
            this.buildObjectKeyToFilepathMapForDirectory(childFile, objectKeyName, objectKeyToFilepathMap, includeDirectories, ignorePatternList);
        }
    }

    public StorageObject[] listObjectsThreaded(StorageService service, final String bucketName, String targetPath, String delimiter, int toDepth) throws ServiceException {
        final List allObjects = Collections.synchronizedList(new ArrayList());
        final List lastCommonPrefixes = Collections.synchronizedList(new ArrayList());
        final ServiceException[] serviceExceptions = new ServiceException[1];
        final ThreadedStorageService threadedService = new ThreadedStorageService(service, new StorageServiceEventAdaptor(){

            public void event(ListObjectsEvent event) {
                if (3 == event.getEventCode()) {
                    for (StorageObjectsChunk chunk : event.getChunkList()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Listed " + chunk.getObjects().length + " objects and " + chunk.getCommonPrefixes().length + " common prefixes in bucket '" + bucketName + "' using prefix=" + chunk.getPrefix() + ", delimiter=" + chunk.getDelimiter());
                        }
                        allObjects.addAll(Arrays.asList(chunk.getObjects()));
                        lastCommonPrefixes.addAll(Arrays.asList(chunk.getCommonPrefixes()));
                    }
                } else if (0 == event.getEventCode()) {
                    serviceExceptions[0] = new ServiceException("Failed to list all objects in bucket", event.getErrorCause());
                }
            }
        });
        String[] prefixesToList = new String[]{targetPath};
        for (int currentDepth = 0; currentDepth <= toDepth && prefixesToList.length > 0; ++currentDepth) {
            if (log.isDebugEnabled()) {
                log.debug("Listing objects in '" + bucketName + "' using " + prefixesToList.length + " prefixes: " + Arrays.asList(prefixesToList));
            }
            lastCommonPrefixes.clear();
            final String[] finalPrefixes = prefixesToList;
            final String finalDelimiter = currentDepth < toDepth ? delimiter : null;
            new Thread(){

                public void run() {
                    threadedService.listObjects(bucketName, finalPrefixes, finalDelimiter, 1000L);
                }
            }.run();
            if (serviceExceptions[0] != null) {
                throw serviceExceptions[0];
            }
            prefixesToList = lastCommonPrefixes.toArray(new String[lastCommonPrefixes.size()]);
        }
        return allObjects.toArray(new StorageObject[allObjects.size()]);
    }

    public StorageObject[] listObjectsThreaded(StorageService service, String bucketName, String targetPath) throws ServiceException {
        String delimiter = null;
        int toDepth = 0;
        String bucketListingProperties = this.jets3tProperties.getStringProperty("filecomparer.bucket-listing." + bucketName, null);
        if (bucketListingProperties != null) {
            String[] splits = bucketListingProperties.split(",");
            if (splits.length != 2) {
                throw new ServiceException("Invalid setting for bucket listing property filecomparer.bucket-listing." + bucketName + ": '" + bucketListingProperties + "'");
            }
            delimiter = splits[0].trim();
            toDepth = Integer.parseInt(splits[1]);
        }
        return this.listObjectsThreaded(service, bucketName, targetPath, delimiter, toDepth);
    }

    public Map<String, StorageObject> buildObjectMap(StorageService service, String bucketName, String targetPath, Map<String, String> objectKeyToFilepathMap, BytesProgressWatcher progressWatcher, StorageServiceEventListener eventListener) throws ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        StorageObject[] objectsIncomplete = this.listObjectsThreaded(service, bucketName, prefix);
        return this.lookupObjectMetadataForPotentialClashes(service, bucketName, targetPath, objectsIncomplete, objectKeyToFilepathMap, progressWatcher, eventListener);
    }

    public PartialObjectListing buildObjectMapPartial(StorageService service, String bucketName, String targetPath, String priorLastKey, Map<String, String> objectKeyToFilepathMap, boolean completeListing, BytesProgressWatcher progressWatcher, StorageServiceEventListener eventListener) throws ServiceException {
        String prefix = targetPath.length() > 0 ? targetPath : null;
        StorageObject[] objects = null;
        String resultPriorLastKey = null;
        if (completeListing) {
            objects = this.listObjectsThreaded(service, bucketName, prefix);
        } else {
            StorageObjectsChunk chunk = service.listObjectsChunked(bucketName, prefix, null, 1000L, priorLastKey, completeListing);
            objects = chunk.getObjects();
            resultPriorLastKey = chunk.getPriorLastKey();
        }
        Map<String, StorageObject> objectsMap = this.lookupObjectMetadataForPotentialClashes(service, bucketName, targetPath, objects, objectKeyToFilepathMap, progressWatcher, eventListener);
        return new PartialObjectListing(objectsMap, resultPriorLastKey);
    }

    public Map<String, StorageObject> lookupObjectMetadataForPotentialClashes(StorageService service, String bucketName, String targetPath, StorageObject[] objectsWithoutMetadata, Map<String, String> objectKeyToFilepathMap, BytesProgressWatcher progressWatcher, StorageServiceEventListener eventListener) throws ServiceException {
        Map<String, StorageObject> objectMap = this.populateObjectMap(targetPath, objectsWithoutMetadata);
        HashSet<StorageObject> objectsForMetadataRetrieval = new HashSet<StorageObject>();
        for (StorageObject object : objectsWithoutMetadata) {
            String filepath;
            String objectKey = object.getKey();
            if (!ServiceUtils.isEtagAlsoAnMD5Hash(object.getETag())) {
                objectsForMetadataRetrieval.add(object);
                continue;
            }
            if (object.isMetadataComplete() || (filepath = objectKeyToFilepathMap.get(objectKey)) == null && object.getContentLength() == 0L && !objectKey.endsWith("/") && "d41d8cd98f00b204e9800998ecf8427e".equals(object.getETag()) && ((filepath = objectKeyToFilepathMap.get(objectKey + "/")) == null || !new File(filepath).isDirectory()) || filepath == null) continue;
            File file = new File(filepath);
            String fileHashAsHex = null;
            try {
                fileHashAsHex = file.isDirectory() ? "" : ServiceUtils.toHex(this.generateFileMD5Hash(file, objectKey, progressWatcher));
            }
            catch (Exception e) {
                throw new ServiceException("Unable to generate MD5 hash for file " + file.getPath(), e);
            }
            if (object.getETag() != null && object.getETag().equals(fileHashAsHex)) continue;
            objectsForMetadataRetrieval.add(object);
        }
        if (objectsForMetadataRetrieval.size() > 0) {
            final ArrayList objectsCompleteList = new ArrayList(objectsWithoutMetadata.length);
            final ServiceException[] serviceExceptions = new ServiceException[1];
            ThreadedStorageService threadedService = new ThreadedStorageService(service, new StorageServiceEventAdaptor(){

                public void event(GetObjectHeadsEvent event) {
                    if (3 == event.getEventCode()) {
                        StorageObject[] finishedObjects = event.getCompletedObjects();
                        if (finishedObjects.length > 0) {
                            objectsCompleteList.addAll(Arrays.asList(finishedObjects));
                        }
                    } else if (0 == event.getEventCode()) {
                        serviceExceptions[0] = new ServiceException("Failed to retrieve detailed information about all objects", event.getErrorCause());
                    }
                }
            });
            if (eventListener != null) {
                threadedService.addServiceEventListener(eventListener);
            }
            threadedService.getObjectsHeads(bucketName, objectsForMetadataRetrieval.toArray(new StorageObject[0]));
            if (serviceExceptions[0] != null) {
                throw serviceExceptions[0];
            }
            StorageObject[] objectsWithMetadata = objectsCompleteList.toArray(new StorageObject[objectsCompleteList.size()]);
            objectMap.putAll(this.populateObjectMap(targetPath, objectsWithMetadata));
        }
        return objectMap;
    }

    public Map<String, StorageObject> populateObjectMap(String targetPath, StorageObject[] objects) {
        TreeMap<String, StorageObject> map = new TreeMap<String, StorageObject>();
        for (int i = 0; i < objects.length; ++i) {
            String relativeKey = objects[i].getKey();
            if (targetPath.length() > 0) {
                int slashIndex = (relativeKey = relativeKey.substring(targetPath.length())).indexOf(Constants.FILE_PATH_DELIM);
                relativeKey = slashIndex == 0 ? relativeKey.substring(slashIndex + 1, relativeKey.length()) : ((slashIndex = targetPath.lastIndexOf(Constants.FILE_PATH_DELIM)) >= 0 ? objects[i].getKey().substring(slashIndex + 1) : objects[i].getKey());
            }
            if (relativeKey.length() <= 0) continue;
            map.put(this.normalizeUnicode(relativeKey), objects[i]);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] generateFileMD5Hash(File file, String relativeFilePath, BytesProgressWatcher progressWatcher) throws IOException, NoSuchAlgorithmException {
        File file2;
        File computedHashFile;
        byte[] computedHash;
        block18: {
            computedHash = null;
            File file3 = computedHashFile = this.getMd5FilesRootDirectoryFile() != null ? new File(this.getMd5FilesRootDirectoryFile(), relativeFilePath + ".md5") : new File(file.getPath() + ".md5");
            if (this.isUseMd5Files() && computedHashFile.canRead() && computedHashFile.lastModified() > file.lastModified()) {
                BufferedReader bufferedReader;
                BufferedReader bufferedReader2 = null;
                try {
                    try {
                        bufferedReader = new BufferedReader(new FileReader(computedHashFile));
                        computedHash = ServiceUtils.fromHex(bufferedReader.readLine().split("\\s")[0]);
                    }
                    catch (Exception e) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to read hash from computed MD5 file", e);
                        }
                        Object var9_16 = null;
                        if (bufferedReader2 != null) {
                            bufferedReader2.close();
                        }
                        break block18;
                    }
                    Object var9_15 = null;
                    if (bufferedReader == null) break block18;
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    if (bufferedReader2 == null) throw throwable;
                    bufferedReader2.close();
                    throw throwable;
                }
                bufferedReader.close();
            }
        }
        if (computedHash == null) {
            void var6_12;
            Object var6_9 = null;
            if (progressWatcher != null) {
                ProgressMonitoredInputStream progressMonitoredInputStream = new ProgressMonitoredInputStream(new FileInputStream(file), progressWatcher);
            } else {
                FileInputStream fileInputStream = new FileInputStream(file);
            }
            computedHash = ServiceUtils.computeMD5Hash((InputStream)var6_12);
        }
        if (!this.isGenerateMd5Files()) return computedHash;
        if (file.getName().endsWith(".md5")) return computedHash;
        if (computedHashFile.exists()) {
            if (computedHashFile.lastModified() >= file.lastModified()) return computedHash;
        }
        if ((file2 = computedHashFile.getParentFile()) != null && !file2.exists()) {
            file2.mkdirs();
        }
        FileWriter fw = null;
        try {
            try {
                fw = new FileWriter(computedHashFile);
                fw.write(ServiceUtils.toHex(computedHash));
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn("Unable to write computed MD5 hash to a file", e);
                }
                Object var11_23 = null;
                if (fw == null) return computedHash;
                fw.close();
                return computedHash;
            }
            Object var11_22 = null;
            if (fw == null) return computedHash;
        }
        catch (Throwable throwable) {
            Object var11_24 = null;
            if (fw == null) throw throwable;
            fw.close();
            throw throwable;
        }
        fw.close();
        return computedHash;
    }

    public FileComparerResults buildDiscrepancyLists(Map<String, String> objectKeyToFilepathMap, Map<String, StorageObject> objectsMap) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        return this.buildDiscrepancyLists(objectKeyToFilepathMap, objectsMap, null);
    }

    public FileComparerResults buildDiscrepancyLists(Map<String, String> objectKeyToFilepathMap, Map<String, StorageObject> objectsMap, BytesProgressWatcher progressWatcher) throws NoSuchAlgorithmException, FileNotFoundException, IOException, ParseException {
        ArrayList<String> onlyOnServerKeys = new ArrayList<String>();
        ArrayList<String> updatedOnServerKeys = new ArrayList<String>();
        ArrayList<String> updatedOnClientKeys = new ArrayList<String>();
        ArrayList<String> onlyOnClientKeys = new ArrayList<String>();
        ArrayList<String> alreadySynchronisedKeys = new ArrayList<String>();
        ArrayList<String> alreadySynchronisedLocalPaths = new ArrayList<String>();
        onlyOnClientKeys.addAll(objectKeyToFilepathMap.keySet());
        for (Map.Entry<String, StorageObject> entry : objectsMap.entrySet()) {
            String keyPath = entry.getKey();
            StorageObject storageObject = entry.getValue();
            String[] splitPathComponents = this.splitFilePathIntoDirPaths(keyPath, storageObject.isDirectoryPlaceholder());
            int componentCount = 0;
            for (String localPath : splitPathComponents) {
                ++componentCount;
                String filepath = objectKeyToFilepathMap.get(localPath);
                if (filepath != null) {
                    File file = new File(filepath);
                    if (file.isDirectory()) {
                        if (componentCount != splitPathComponents.length) continue;
                        alreadySynchronisedKeys.add(keyPath);
                        alreadySynchronisedLocalPaths.add(localPath);
                        boolean wasRemoved = onlyOnClientKeys.remove(keyPath);
                        if (wasRemoved || keyPath.endsWith("/") || !storageObject.isDirectoryPlaceholder()) continue;
                        onlyOnClientKeys.remove(keyPath + "/");
                        continue;
                    }
                    String fileHashAsBase64 = ServiceUtils.toBase64(this.generateFileMD5Hash(file, localPath, progressWatcher));
                    String objectHash = null;
                    if (storageObject.containsMetadata("original-md5-hash")) {
                        objectHash = (String)storageObject.getMetadata("original-md5-hash");
                        if (log.isDebugEnabled()) {
                            log.debug("Object in service is encoded, using the object's original hash value for: " + storageObject.getKey());
                        }
                    } else {
                        objectHash = storageObject.getMd5HashAsBase64();
                    }
                    if (fileHashAsBase64.equals(objectHash)) {
                        alreadySynchronisedKeys.add(keyPath);
                        alreadySynchronisedLocalPaths.add(localPath);
                        onlyOnClientKeys.remove(keyPath);
                        continue;
                    }
                    Date objectLastModified = null;
                    String metadataLocalFileDate = (String)storageObject.getMetadata("jets3t-original-file-date-iso8601");
                    if (metadataLocalFileDate == null) {
                        if (!this.isAssumeLocalLatestInMismatch() && log.isWarnEnabled()) {
                            log.warn("Using service last modified date as file date. This is not reliable as the time according to service can differ from your local system time. Please use the metadata item jets3t-original-file-date-iso8601");
                        }
                        objectLastModified = storageObject.getLastModifiedDate();
                    } else {
                        objectLastModified = ServiceUtils.parseIso8601Date(metadataLocalFileDate);
                    }
                    if (objectLastModified.getTime() > file.lastModified()) {
                        updatedOnServerKeys.add(keyPath);
                        onlyOnClientKeys.remove(keyPath);
                        continue;
                    }
                    if (objectLastModified.getTime() < file.lastModified()) {
                        updatedOnClientKeys.add(keyPath);
                        onlyOnClientKeys.remove(keyPath);
                        continue;
                    }
                    if (this.isAssumeLocalLatestInMismatch()) {
                        if (log.isWarnEnabled()) {
                            log.warn("Backed-up object " + storageObject.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "Assuming local file is the latest version.");
                        }
                        updatedOnClientKeys.add(keyPath);
                        onlyOnClientKeys.remove(keyPath);
                        continue;
                    }
                    throw new IOException("Backed-up object " + storageObject.getKey() + " and local file " + file.getName() + " have the same date but different hash values. " + "This shouldn't happen!");
                }
                if (componentCount != splitPathComponents.length) continue;
                onlyOnServerKeys.add(keyPath);
                onlyOnClientKeys.remove(keyPath);
            }
        }
        return new FileComparerResults(onlyOnServerKeys, updatedOnServerKeys, updatedOnClientKeys, onlyOnClientKeys, alreadySynchronisedKeys, alreadySynchronisedLocalPaths);
    }

    private String[] splitFilePathIntoDirPaths(String path, boolean isDirectoryPlaceholder) {
        String[] pathComponents = path.split(Constants.FILE_PATH_DELIM);
        String[] dirPathsInOrder = new String[pathComponents.length];
        String myPath = "";
        for (int i = 0; i < pathComponents.length; ++i) {
            String pathComponent = pathComponents[i];
            myPath = myPath + pathComponent;
            if (i < pathComponents.length - 1 || isDirectoryPlaceholder) {
                myPath = myPath + Constants.FILE_PATH_DELIM;
            }
            dirPathsInOrder[i] = myPath;
        }
        return dirPathsInOrder;
    }

    public boolean isSkipSymlinks() {
        return this.jets3tProperties.getBoolProperty("filecomparer.skip-symlinks", false);
    }

    public boolean isUseMd5Files() {
        return this.jets3tProperties.getBoolProperty("filecomparer.use-md5-files", false);
    }

    public boolean isGenerateMd5Files() {
        return this.jets3tProperties.getBoolProperty("filecomparer.generate-md5-files", false);
    }

    public boolean isSkipMd5FileUpload() {
        return this.jets3tProperties.getBoolProperty("filecomparer.skip-upload-of-md5-files", false);
    }

    public boolean isAssumeLocalLatestInMismatch() {
        return this.jets3tProperties.getBoolProperty("filecomparer.assume-local-latest-in-mismatch", false);
    }

    public File getMd5FilesRootDirectoryFile() throws FileNotFoundException {
        String dirPath = this.jets3tProperties.getStringProperty("filecomparer.md5-files-root-dir", null);
        if (dirPath != null) {
            File dirFile = new File(dirPath);
            if (!dirFile.isDirectory()) {
                throw new FileNotFoundException("filecomparer.md5-files-root-dir path is not a directory: " + dirPath);
            }
            return dirFile;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PartialObjectListing {
        private Map<String, StorageObject> objectsMap = null;
        private String priorLastKey = null;

        public PartialObjectListing(Map<String, StorageObject> objectsMap, String priorLastKey) {
            this.objectsMap = objectsMap;
            this.priorLastKey = priorLastKey;
        }

        public Map<String, StorageObject> getObjectsMap() {
            return this.objectsMap;
        }

        public String getPriorLastKey() {
            return this.priorLastKey;
        }
    }
}

