/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.PropertyKey;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.gcs.GCSInputStream;
import alluxio.underfs.gcs.GCSOutputStream;
import alluxio.underfs.gcs.GCSUtils;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.model.GSObject;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GCSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(GCSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final byte[] DIR_HASH;
    private final GoogleStorageService mClient;
    private final String mBucketName;
    private final String mAccountOwner;
    private final short mBucketMode;

    public static GCSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws ServiceException {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.GCS_ACCESS_KEY), (Object)("Property " + PropertyKey.GCS_ACCESS_KEY + " is required to connect to GCS"));
        Preconditions.checkArgument((boolean)conf.containsKey(PropertyKey.GCS_SECRET_KEY), (Object)("Property " + PropertyKey.GCS_SECRET_KEY + " is required to connect to GCS"));
        GSCredentials googleCredentials = new GSCredentials(conf.getValue(PropertyKey.GCS_ACCESS_KEY), conf.getValue(PropertyKey.GCS_SECRET_KEY));
        GoogleStorageService googleStorageService = new GoogleStorageService((ProviderCredentials)googleCredentials);
        StorageOwner storageOwner = googleStorageService.getAccountOwner();
        String accountOwnerId = "unknown";
        String accountOwner = "unknown";
        if (storageOwner != null) {
            accountOwnerId = storageOwner.getId();
            String owner = CommonUtils.getValueFromStaticMapping((String)conf.getValue(PropertyKey.UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING), (String)accountOwnerId);
            if (owner == null) {
                owner = storageOwner.getDisplayName();
            }
            accountOwner = owner == null ? accountOwnerId : owner;
        } else {
            LOG.debug("GoogleStorageService returns a null StorageOwner with this Google Cloud account.");
        }
        GSAccessControlList acl = googleStorageService.getBucketAcl(bucketName);
        short bucketMode = GCSUtils.translateBucketAcl(acl, accountOwnerId);
        return new GCSUnderFileSystem(uri, googleStorageService, bucketName, bucketMode, accountOwner, conf);
    }

    protected GCSUnderFileSystem(AlluxioURI uri, GoogleStorageService googleStorageService, String bucketName, short bucketMode, String accountOwner, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = googleStorageService;
        this.mBucketName = bucketName;
        this.mBucketMode = bucketMode;
        this.mAccountOwner = accountOwner;
    }

    public String getUnderFSType() {
        return "gcs";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        GSObject obj = new GSObject(dst);
        int retries = 3;
        for (int i = 0; i < retries; ++i) {
            try {
                this.mClient.copyObject(this.mBucketName, src, this.mBucketName, (StorageObject)obj, false);
                return true;
            }
            catch (ServiceException e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
                if (i == retries - 1) continue;
                LOG.error("Retrying copying file {} to {}", (Object)src, (Object)dst);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{src, dst, retries});
        return false;
    }

    protected boolean createEmptyObject(String key) {
        try {
            GSObject obj = new GSObject(key);
            obj.setDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new GCSOutputStream(this.mBucketName, key, this.mClient);
    }

    protected boolean deleteObject(String key) throws IOException {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter;
        StorageObjectsChunk chunk = this.getObjectListingChunk(key = (key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : key, delimiter = recursive ? "" : PATH_SEPARATOR, null);
        if (chunk != null) {
            return new GCSObjectListingChunk(chunk);
        }
        return null;
    }

    private StorageObjectsChunk getObjectListingChunk(String key, String delimiter, String priorLastKey) {
        StorageObjectsChunk res;
        try {
            res = this.mClient.listObjectsChunked(this.mBucketName, key, delimiter, (long)this.getListingChunkLength(), priorLastKey);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)key, (Object)e);
            res = null;
        }
        return res;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            GSObject meta = this.mClient.getObjectDetails(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, meta.getMd5HashAsBase64(), meta.getContentLength(), meta.getLastModifiedDate().getTime());
        }
        catch (ServiceException e) {
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, this.mAccountOwner, this.mAccountOwner, this.mBucketMode);
    }

    protected String getRootKey() {
        return "gs://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options) throws IOException {
        try {
            return new GCSInputStream(this.mBucketName, key, this.mClient, options.getOffset());
        }
        catch (ServiceException e) {
            throw new IOException(e.getMessage());
        }
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class GCSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final StorageObjectsChunk mChunk;

        GCSObjectListingChunk(StorageObjectsChunk chunk) throws IOException {
            this.mChunk = chunk;
            if (this.mChunk == null) {
                throw new IOException("GCS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            StorageObject[] objects = this.mChunk.getObjects();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)GCSUnderFileSystem.this, objects[i].getKey(), objects[i].getMd5HashAsBase64(), objects[i].getContentLength(), objects[i].getLastModifiedDate().getTime());
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            return this.mChunk.getCommonPrefixes();
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            StorageObjectsChunk nextChunk;
            if (!this.mChunk.isListingComplete() && (nextChunk = GCSUnderFileSystem.this.getObjectListingChunk(this.mChunk.getPrefix(), this.mChunk.getDelimiter(), this.mChunk.getPriorLastKey())) != null) {
                return new GCSObjectListingChunk(nextChunk);
            }
            return null;
        }
    }
}

