/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.retry.RetryPolicy;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.model.GSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class GCSInputStream
extends InputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GCSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final GoogleStorageService mClient;
    private BufferedInputStream mInputStream;
    private long mPos;
    private final RetryPolicy mRetryPolicy;

    GCSInputStream(String bucketName, String key, GoogleStorageService client, RetryPolicy retryPolicy) {
        this(bucketName, key, client, 0L, retryPolicy);
    }

    GCSInputStream(String bucketName, String key, GoogleStorageService client, long pos, RetryPolicy retryPolicy) {
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mPos = pos;
        this.mRetryPolicy = retryPolicy;
    }

    @Override
    public void close() throws IOException {
        this.closeStream();
    }

    @Override
    public int read() throws IOException {
        int value;
        if (this.mInputStream == null) {
            this.openStream();
        }
        if ((value = this.mInputStream.read()) != -1) {
            ++this.mPos;
        }
        return value;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if (len == 0) {
            return 0;
        }
        if (this.mInputStream == null) {
            this.openStream();
        }
        if ((ret = this.mInputStream.read(b, off, len)) != -1) {
            this.mPos += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if ((long)this.mInputStream.available() >= n) {
            return this.mInputStream.skip(n);
        }
        this.closeStream();
        this.mPos += n;
        this.openStream();
        return n;
    }

    private void openStream() throws IOException {
        ServiceException lastException = null;
        while (this.mRetryPolicy.attempt()) {
            try {
                GSObject object = this.mPos > 0L ? this.mClient.getObject(this.mBucketName, this.mKey, null, null, null, null, Long.valueOf(this.mPos), null) : this.mClient.getObject(this.mBucketName, this.mKey);
                this.mInputStream = new BufferedInputStream(object.getDataInputStream());
                return;
            }
            catch (ServiceException e) {
                LOG.warn("Attempt {} to open key {} on position {} in bucket {} failed with exception : {}", new Object[]{this.mRetryPolicy.getAttemptCount(), this.mKey, this.mPos, this.mBucketName, e.toString()});
                if (e.getResponseCode() != 404) {
                    throw new IOException(e);
                }
                lastException = e;
            }
        }
        throw new IOException(lastException);
    }

    private void closeStream() throws IOException {
        if (this.mInputStream == null) {
            return;
        }
        this.mInputStream.close();
        this.mInputStream = null;
    }
}

