/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.gcs.GCSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GCSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GCSUnderFileSystemFactory.class);

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (this.checkGoogleCredentials(conf)) {
            try {
                return GCSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (ServiceException e) {
                LOG.error("Failed to create GCSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "Google Credentials not available, cannot create GCS Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("gs://");
    }

    private boolean checkGoogleCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.GCS_ACCESS_KEY) && conf.isSet(PropertyKey.GCS_SECRET_KEY);
    }
}

