/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.acl.gs.GSAccessControlList;

public final class GCSUtils {
    public static short translateBucketAcl(GSAccessControlList acl, String userId) {
        short mode = 0;
        for (GrantAndPermission gp : acl.getGrantAndPermissions()) {
            Permission perm = gp.getPermission();
            GranteeInterface grantee = gp.getGrantee();
            if (perm.equals((Object)Permission.PERMISSION_READ)) {
                if (!GCSUtils.isUserIdInGrantee(grantee, userId)) continue;
                mode = (short)(mode | 0x140);
                continue;
            }
            if (perm.equals((Object)Permission.PERMISSION_WRITE)) {
                if (!GCSUtils.isUserIdInGrantee(grantee, userId)) continue;
                mode = (short)(mode | 0x80);
                continue;
            }
            if (!perm.equals((Object)Permission.PERMISSION_FULL_CONTROL) || !GCSUtils.isUserIdInGrantee(grantee, userId)) continue;
            mode = (short)(mode | 0x1C0);
        }
        return mode;
    }

    private static boolean isUserIdInGrantee(GranteeInterface grantee, String userId) {
        return grantee.getIdentifier().equals(userId) || grantee.equals(GroupGrantee.ALL_USERS) || grantee.equals(GroupGrantee.AUTHENTICATED_USERS);
    }

    private GCSUtils() {
    }
}

