/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.gcs.GCSUnderFileSystem;
import alluxio.underfs.gcs.v2.GCSV2UnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GCSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GCSUnderFileSystemFactory.class);
    private static final String GCS_VERSION_TWO = "2";

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"path");
        if (conf.get(PropertyKey.UNDERFS_GCS_VERSION).equals(GCS_VERSION_TWO)) {
            try {
                return GCSV2UnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (IOException e) {
                LOG.error("Failed to create GCSV2UnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        try {
            return GCSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
        }
        catch (ServiceException e) {
            LOG.error("Failed to create GCSUnderFileSystem.", (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("gs://");
    }
}

