/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.v2;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.gcs.v2.GCSV2InputStream;
import alluxio.underfs.gcs.v2.GCSV2OutputStream;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.ModeUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.api.client.util.Base64;
import com.google.api.gax.paging.Page;
import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.cloud.storage.StorageOptions;
import com.google.common.collect.Lists;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.threeten.bp.Duration;

@ThreadSafe
public class GCSV2UnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(GCSV2UnderFileSystem.class);
    private static final String DIR_HASH = Base64.encodeBase64String((byte[])DigestUtils.md5((byte[])new byte[0]));
    private final Storage mStorageClient;
    private final String mBucketName;

    public static GCSV2UnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws IOException {
        GoogleCredentials credentials;
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        if (conf.isSet(PropertyKey.GCS_CREDENTIAL_PATH)) {
            String credsPath = conf.get(PropertyKey.GCS_CREDENTIAL_PATH);
            credentials = GoogleCredentials.fromStream((InputStream)new FileInputStream(credsPath)).createScoped((Collection)Lists.newArrayList((Object[])new String[]{"https://www.googleapis.com/auth/cloud-platform"}));
            LOG.info("Created GCSV2UnderFileSystem with credentials in {}", (Object)credsPath);
        } else {
            credentials = GoogleCredentials.getApplicationDefault();
            LOG.info("Created GCSV2UnderFileSystem with default Google application credentials");
        }
        Storage storage = (Storage)((StorageOptions.Builder)((StorageOptions.Builder)StorageOptions.newBuilder().setRetrySettings(RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)conf.getInt(PropertyKey.UNDERFS_GCS_RETRY_INITIAL_DELAY_MS))).setMaxRetryDelay(Duration.ofMillis((long)conf.getInt(PropertyKey.UNDERFS_GCS_RETRY_MAX_DELAY_MS))).setRetryDelayMultiplier((double)conf.getInt(PropertyKey.UNDERFS_GCS_RETRY_DELAY_MULTIPLIER)).setMaxAttempts(conf.getInt(PropertyKey.UNDERFS_GCS_RETRY_MAX)).setTotalTimeout(Duration.ofMillis((long)conf.getInt(PropertyKey.UNDERFS_GCS_RETRY_TOTAL_DURATION_MS))).setJittered(conf.getBoolean(PropertyKey.UNDERFS_GCS_RETRY_JITTER)).build())).setCredentials((Credentials)credentials)).build().getService();
        return new GCSV2UnderFileSystem(uri, storage, bucketName, conf);
    }

    protected GCSV2UnderFileSystem(AlluxioURI uri, Storage storageClient, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mStorageClient = storageClient;
        this.mBucketName = bucketName;
    }

    public String getUnderFSType() {
        return "gcs";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) {
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        Storage.CopyRequest request = Storage.CopyRequest.newBuilder().setSource(BlobId.of((String)this.mBucketName, (String)src)).setTarget(BlobId.of((String)this.mBucketName, (String)dst)).build();
        try {
            Blob blob = this.mStorageClient.copy(request).getResult();
            if (blob != null) {
                return true;
            }
        }
        catch (StorageException e) {
            LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
        }
        return false;
    }

    public boolean createEmptyObject(String key) {
        try {
            BlobId blobId = BlobId.of((String)this.mBucketName, (String)key);
            BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).build();
            Blob blob = this.mStorageClient.create(blobInfo, new Storage.BlobTargetOption[0]);
            if (blob == null) {
                LOG.error("Failed to create object {}", (Object)key);
                return false;
            }
        }
        catch (StorageException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected OutputStream createObject(String key) throws IOException {
        return new GCSV2OutputStream(this.mBucketName, key, this.mStorageClient);
    }

    protected boolean deleteObject(String key) {
        BlobId blobId = BlobId.of((String)this.mBucketName, (String)key);
        try {
            if (!this.mStorageClient.delete(blobId)) {
                LOG.error("Failed to delete object {}", (Object)key);
                return false;
            }
        }
        catch (StorageException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return this.mUfsConf.get(PropertyKey.UNDERFS_GCS_DIRECTORY_SUFFIX);
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        Page blobPage;
        key = (key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? "" : key;
        try {
            blobPage = recursive ? this.mStorageClient.list(this.mBucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)key)}) : this.mStorageClient.list(this.mBucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)key), Storage.BlobListOption.currentDirectory()});
        }
        catch (StorageException e) {
            LOG.error("Failed to get object listing result of {}", (Object)key, (Object)e);
            throw new IOException(e);
        }
        if (blobPage != null && blobPage.getValues().iterator().hasNext()) {
            return new GCSObjectListingChunk((Page<Blob>)blobPage);
        }
        return null;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) throws IOException {
        try {
            BlobId info = BlobId.of((String)this.mBucketName, (String)key);
            Blob blob = this.mStorageClient.get(info);
            if (blob == null) {
                return null;
            }
            return this.getBlobStatus(blob);
        }
        catch (StorageException e) {
            if (e.getCode() == 404) {
                return null;
            }
            throw new IOException(String.format("Failed to get object status of %s, %s", key, this.mBucketName), e);
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, "", "", ModeUtils.getUMask((String)this.mUfsConf.get(PropertyKey.UNDERFS_GCS_DEFAULT_MODE)).toShort());
    }

    protected String getRootKey() {
        return "gs://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        return new GCSV2InputStream(this.mBucketName, key, this.mStorageClient, options.getOffset());
    }

    private ObjectUnderFileSystem.ObjectStatus getBlobStatus(Blob blob) {
        long time = blob.getUpdateTime() != null ? blob.getUpdateTime() : (blob.getCreateTime() != null ? blob.getCreateTime() : -1L);
        return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, blob.getName(), blob.getMd5() == null ? DIR_HASH : blob.getMd5(), blob.getSize().longValue(), time);
    }

    private final class GCSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final Page<Blob> mBlobPage;

        GCSObjectListingChunk(Page<Blob> blobPage) {
            this.mBlobPage = blobPage;
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            Iterator blobs = this.mBlobPage.getValues().iterator();
            ArrayList<Blob> blobList = new ArrayList<Blob>();
            while (blobs.hasNext()) {
                blobList.add((Blob)blobs.next());
            }
            ObjectUnderFileSystem.ObjectStatus[] res = new ObjectUnderFileSystem.ObjectStatus[blobList.size()];
            for (int i = 0; i < res.length; ++i) {
                Blob blob = (Blob)blobList.get(i);
                res[i] = GCSV2UnderFileSystem.this.getBlobStatus(blob);
            }
            return res;
        }

        public String[] getCommonPrefixes() {
            return new String[0];
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() {
            if (this.mBlobPage.hasNextPage()) {
                return new GCSObjectListingChunk((Page<Blob>)this.mBlobPage.getNextPage());
            }
            return null;
        }
    }
}

