/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.v2;

import alluxio.underfs.ContentHashable;
import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class GCSV2OutputStream
extends OutputStream
implements ContentHashable {
    private static final Logger LOG = LoggerFactory.getLogger(GCSV2OutputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final Storage mClient;
    private final ByteBuffer mSingleByteBuffer;
    private final BlobInfo mBlobInfo;
    private WriteChannel mWriteChannel;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);
    private String mContentHash;

    public GCSV2OutputStream(String bucketName, String key, Storage client) {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mSingleByteBuffer = ByteBuffer.allocate(1);
        this.mBlobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)this.mBucketName, (String)this.mKey)).build();
        try {
            this.mHash = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.mHash != null) {
            this.mHash.update((byte)b);
        }
        if (this.mWriteChannel == null) {
            this.createWriteChannel();
        }
        this.mSingleByteBuffer.clear();
        this.mSingleByteBuffer.putInt(b);
        try {
            this.mWriteChannel.write(this.mSingleByteBuffer);
        }
        catch (StorageException e) {
            throw new IOException(String.format("Failed to write to a channel of %s in %s", this.mKey, this.mBucketName), e);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.mHash != null) {
            this.mHash.update(b, off, len);
        }
        if (this.mWriteChannel == null) {
            this.createWriteChannel();
        }
        ByteBuffer buffer = ByteBuffer.wrap(b, off, len);
        try {
            this.mWriteChannel.write(buffer);
        }
        catch (StorageException e) {
            throw new IOException(String.format("Failed to write to a channel of %s in %s", this.mKey, this.mBucketName), e);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        try {
            if (this.mWriteChannel != null) {
                this.mWriteChannel.close();
            } else {
                Blob blob = this.mClient.create(this.mBlobInfo, new Storage.BlobTargetOption[0]);
                if (blob == null) {
                    throw new IOException(String.format("Failed to create empty object %s in %s", this.mKey, this.mBucketName));
                }
                this.mContentHash = blob.getMd5();
            }
        }
        catch (ClosedChannelException e) {
            LOG.error("Channel already closed, possible duplicate close call.", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error("Failed to upload {} to {}", new Object[]{this.mKey, this.mBucketName, e});
            throw e;
        }
    }

    private void createWriteChannel() throws IOException {
        try {
            this.mWriteChannel = this.mClient.writer(this.mBlobInfo, new Storage.BlobWriteOption[0]);
        }
        catch (StorageException e) {
            throw new IOException(String.format("Failed to create write channel of %s in %s", this.mKey, this.mBucketName), e);
        }
    }

    public Optional<String> getContentHash() {
        if (this.mContentHash != null) {
            return Optional.of(this.mContentHash);
        }
        return Optional.empty();
    }
}

