/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs.v2;

import com.google.cloud.ReadChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class GCSV2InputStream
extends InputStream {
    private final String mBucketName;
    private final String mKey;
    private final Storage mClient;
    private final ByteBuffer mSingleByteBuffer;
    private ReadChannel mReadChannel;
    private long mPos;

    GCSV2InputStream(String bucketName, String key, Storage client, long pos) {
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mClient = client;
        this.mPos = pos;
        this.mSingleByteBuffer = ByteBuffer.allocate(1);
    }

    @Override
    public void close() throws IOException {
        if (this.mReadChannel != null) {
            this.mReadChannel.close();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.mReadChannel == null) {
            this.openStream();
        }
        this.mSingleByteBuffer.clear();
        int num = this.mReadChannel.read(this.mSingleByteBuffer);
        if (num != -1) {
            ++this.mPos;
        } else {
            return -1;
        }
        this.mSingleByteBuffer.position(0);
        return this.mSingleByteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret;
        if (len == 0) {
            return 0;
        }
        if (this.mReadChannel == null) {
            this.openStream();
        }
        if ((ret = this.mReadChannel.read(ByteBuffer.wrap(b, off, len))) != -1) {
            this.mPos += (long)ret;
        }
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        this.mPos += n;
        if (this.mReadChannel == null) {
            this.openStream();
        } else {
            this.mReadChannel.seek(this.mPos);
        }
        return n;
    }

    private void openStream() throws IOException {
        block4: {
            try {
                this.mReadChannel = this.mClient.reader(BlobId.of((String)this.mBucketName, (String)this.mKey), new Storage.BlobSourceOption[0]);
                if (this.mReadChannel != null) {
                    if (this.mPos > 0L) {
                        this.mReadChannel.seek(this.mPos);
                    }
                    break block4;
                }
                throw new IOException(String.format("Failed to open stream of %s in %s", this.mKey, this.mBucketName));
            }
            catch (StorageException e) {
                throw new IOException(String.format("Failed to open stream of %s in %s", this.mKey, this.mBucketName), e);
            }
        }
    }
}

