/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.gcs.GCSInputStream;
import alluxio.underfs.gcs.GCSOutputStream;
import alluxio.underfs.gcs.GCSPositionReader;
import alluxio.underfs.gcs.GCSUtils;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.ModeUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.jets3t.service.StorageObjectsChunk;
import org.jets3t.service.acl.gs.GSAccessControlList;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.model.GSObject;
import org.jets3t.service.model.StorageObject;
import org.jets3t.service.model.StorageOwner;
import org.jets3t.service.security.GSCredentials;
import org.jets3t.service.security.ProviderCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GCSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(GCSUnderFileSystem.class);
    private static final String DEFAULT_OWNER = "";
    private static final byte[] DIR_HASH;
    private final GoogleStorageService mClient;
    private final String mBucketName;
    private final Supplier<ObjectUnderFileSystem.ObjectPermissions> mPermissions = CommonUtils.memoize(this::getPermissionsInternal);

    public static GCSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) throws ServiceException {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.GCS_ACCESS_KEY), (Object)("Property " + PropertyKey.GCS_ACCESS_KEY + " is required to connect to GCS"));
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.GCS_SECRET_KEY), (Object)("Property " + PropertyKey.GCS_SECRET_KEY + " is required to connect to GCS"));
        GSCredentials googleCredentials = new GSCredentials(conf.getString(PropertyKey.GCS_ACCESS_KEY), conf.getString(PropertyKey.GCS_SECRET_KEY));
        GoogleStorageService googleStorageService = new GoogleStorageService((ProviderCredentials)googleCredentials);
        return new GCSUnderFileSystem(uri, googleStorageService, bucketName, conf);
    }

    protected GCSUnderFileSystem(AlluxioURI uri, GoogleStorageService googleStorageService, String bucketName, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = googleStorageService;
        this.mBucketName = bucketName;
    }

    public String getUnderFSType() {
        return "gcs";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    public UfsDirectoryStatus getExistingDirectoryStatus(String path) throws IOException {
        return this.getDirectoryStatus(path);
    }

    public InputStream openExistingFile(String path) throws IOException {
        return this.open(path);
    }

    public InputStream openExistingFile(String path, OpenOptions options) throws IOException {
        return this.open(path, options);
    }

    public PositionReader openPositionRead(String path, long fileLength) {
        return new GCSPositionReader(this.mClient, this.mBucketName, this.stripPrefixIfPresent(path), fileLength);
    }

    protected boolean copyObject(String src, String dst) {
        LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
        GSObject obj = new GSObject(dst);
        int retries = 3;
        for (int i = 0; i < retries; ++i) {
            try {
                this.mClient.copyObject(this.mBucketName, src, this.mBucketName, (StorageObject)obj, false);
                return true;
            }
            catch (ServiceException e) {
                LOG.error("Failed to copy file {} to {}", new Object[]{src, dst, e});
                if (i == retries - 1) continue;
                LOG.error("Retrying copying file {} to {}", (Object)src, (Object)dst);
                continue;
            }
        }
        LOG.error("Failed to copy file {} to {}, after {} retries", new Object[]{src, dst, retries});
        return false;
    }

    public boolean createEmptyObject(String key) {
        try {
            GSObject obj = new GSObject(key);
            obj.setDataInputStream((InputStream)new ByteArrayInputStream(new byte[0]));
            obj.setContentLength(0L);
            obj.setMd5Hash(DIR_HASH);
            obj.setContentType("binary/octet-stream");
            this.mClient.putObject(this.mBucketName, obj);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new GCSOutputStream(this.mBucketName, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) throws IOException {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected String getFolderSuffix() {
        return this.mUfsConf.getString(PropertyKey.UNDERFS_GCS_DIRECTORY_SUFFIX);
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter;
        StorageObjectsChunk chunk = this.getObjectListingChunk(key = (key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR)).equals(PATH_SEPARATOR) ? DEFAULT_OWNER : key, delimiter = recursive ? DEFAULT_OWNER : PATH_SEPARATOR, null);
        if (chunk != null) {
            return new GCSObjectListingChunk(chunk);
        }
        return null;
    }

    private StorageObjectsChunk getObjectListingChunk(String key, String delimiter, String priorLastKey) {
        StorageObjectsChunk res;
        try {
            res = this.mClient.listObjectsChunked(this.mBucketName, key, delimiter, (long)this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf), priorLastKey);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)key, (Object)e);
            res = null;
        }
        return res;
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) throws IOException {
        try {
            GSObject meta = this.mClient.getObjectDetails(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus(key, meta.getMd5HashAsBase64(), meta.getContentLength(), Long.valueOf(meta.getLastModifiedDate().getTime()));
        }
        catch (ServiceException e) {
            if (e.getResponseCode() == 404) {
                return null;
            }
            throw new IOException(e);
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return this.mPermissions.get();
    }

    private ObjectUnderFileSystem.ObjectPermissions getPermissionsInternal() {
        String accountOwnerId = DEFAULT_OWNER;
        String accountOwner = DEFAULT_OWNER;
        try {
            StorageOwner storageOwner = this.mClient.getAccountOwner();
            if (storageOwner != null) {
                accountOwnerId = storageOwner.getId();
                String owner = CommonUtils.getValueFromStaticMapping((String)this.mUfsConf.getString(PropertyKey.UNDERFS_GCS_OWNER_ID_TO_USERNAME_MAPPING), (String)accountOwnerId);
                if (owner == null) {
                    owner = storageOwner.getDisplayName();
                }
                accountOwner = owner == null ? accountOwnerId : owner;
            } else {
                LOG.debug("GoogleStorageService returns a null StorageOwner with this Google Cloud account.");
            }
        }
        catch (ServiceException e) {
            LOG.warn("Failed to get Google account owner, proceeding with defaults owner {}. {}", (Object)accountOwner, (Object)e.toString());
        }
        short bucketMode = ModeUtils.getUMask((String)this.mUfsConf.getString(PropertyKey.UNDERFS_GCS_DEFAULT_MODE)).toShort();
        try {
            GSAccessControlList acl = this.mClient.getBucketAcl(this.mBucketName);
            bucketMode = GCSUtils.translateBucketAcl(acl, accountOwnerId);
        }
        catch (ServiceException e) {
            LOG.warn("Failed to inherit bucket ACLs, proceeding with defaults. {}", (Object)e.toString());
        }
        return new ObjectUnderFileSystem.ObjectPermissions(accountOwner, accountOwner, bucketMode);
    }

    protected String getRootKey() {
        return "gs://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) {
        return new GCSInputStream(this.mBucketName, key, this.mClient, options.getOffset(), retryPolicy);
    }

    static {
        try {
            DIR_HASH = MessageDigest.getInstance("MD5").digest(new byte[0]);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private final class GCSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final StorageObjectsChunk mChunk;

        GCSObjectListingChunk(StorageObjectsChunk chunk) throws IOException {
            this.mChunk = chunk;
            if (this.mChunk == null) {
                throw new IOException("GCS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            StorageObject[] objects = this.mChunk.getObjects();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.length];
            for (int i = 0; i < ret.length; ++i) {
                Date lastModifiedDate = objects[i].getLastModifiedDate();
                Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
                ret[i] = new ObjectUnderFileSystem.ObjectStatus(objects[i].getKey(), objects[i].getMd5HashAsBase64(), objects[i].getContentLength(), lastModifiedTime);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            return this.mChunk.getCommonPrefixes();
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            StorageObjectsChunk nextChunk;
            if (!this.mChunk.isListingComplete() && (nextChunk = GCSUnderFileSystem.this.getObjectListingChunk(this.mChunk.getPrefix(), this.mChunk.getDelimiter(), this.mChunk.getPriorLastKey())) != null) {
                return new GCSObjectListingChunk(nextChunk);
            }
            return null;
        }
    }
}

