/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.exception.runtime.InvalidArgumentRuntimeException;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.gcs.GCSUnderFileSystem;
import alluxio.underfs.gcs.v2.GCSV2UnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GCSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GCSUnderFileSystemFactory.class);
    private static final int GCS_VERSION_TWO = 2;

    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"Unable to create UnderFileSystem instance: URI path should not be null");
        if (conf.getInt(PropertyKey.UNDERFS_GCS_VERSION) == 2) {
            try {
                return GCSV2UnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (IOException e) {
                LOG.error("Failed to create GCSV2UnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (this.checkGCSCredentials(conf)) {
            try {
                return GCSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (ServiceException e) {
                LOG.error("Failed to create GCSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "GCS credentials or version not available, cannot create GCS Under File System.";
        throw new InvalidArgumentRuntimeException(err);
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("gs://");
    }

    private boolean checkGCSCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.GCS_ACCESS_KEY) && conf.isSet(PropertyKey.GCS_SECRET_KEY);
    }
}

