/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.gcs;

import alluxio.underfs.ObjectPositionReader;
import java.io.InputStream;
import javax.annotation.concurrent.ThreadSafe;
import org.jets3t.service.ServiceException;
import org.jets3t.service.impl.rest.httpclient.GoogleStorageService;
import org.jets3t.service.model.GSObject;

@ThreadSafe
public class GCSPositionReader
extends ObjectPositionReader {
    protected final GoogleStorageService mClient;

    public GCSPositionReader(GoogleStorageService client, String bucketName, String path, long fileLength) {
        super(bucketName, path, fileLength);
        this.mClient = client;
    }

    protected InputStream openObjectInputStream(long position, int bytesToRead) {
        GSObject object;
        try {
            object = this.mClient.getObject(this.mBucketName, this.mPath, null, null, null, null, Long.valueOf(position), Long.valueOf(position + (long)bytesToRead - 1L));
        }
        catch (ServiceException e) {
            String errorMessage = String.format("Failed to get object: %s bucket: %s", this.mPath, this.mBucketName);
            throw new RuntimeException(errorMessage, e);
        }
        try {
            return object.getDataInputStream();
        }
        catch (ServiceException e) {
            String errorMessage = String.format("Failed to open GCS InputStream", new Object[0]);
            throw new RuntimeException(errorMessage, e);
        }
    }
}

