/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.glusterfs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GlusterFSUnderFileSystem
extends HdfsUnderFileSystem {
    public static final String SCHEME = "glusterfs://";

    public GlusterFSUnderFileSystem(AlluxioURI uri, Configuration configuration, Object conf) {
        super(uri, configuration, conf);
    }

    public UnderFileSystem.UnderFSType getUnderFSType() {
        return UnderFileSystem.UnderFSType.GLUSTERFS;
    }

    protected void prepareConfiguration(String path, Configuration conf, org.apache.hadoop.conf.Configuration hadoopConf) {
        if (path.startsWith(SCHEME)) {
            hadoopConf.set("fs.glusterfs.impl", conf.get("alluxio.underfs.glusterfs.impl"));
            hadoopConf.set("mapred.system.dir", conf.get("alluxio.underfs.glusterfs.mapred.system.dir"));
            hadoopConf.set("fs.glusterfs.volumes", conf.get("alluxio.underfs.glusterfs.volumes"));
            hadoopConf.set("fs.glusterfs.volume.fuse." + conf.get("alluxio.underfs.glusterfs.volumes"), conf.get("alluxio.underfs.glusterfs.mounts"));
        } else {
            super.prepareConfiguration(path, conf, hadoopConf);
        }
    }
}

