/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.glusterfs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.glusterfs.GlusterFSUnderFileSystem;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GlusterFSUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, Configuration configuration, Object conf) {
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"path may not be null");
        return new GlusterFSUnderFileSystem(new AlluxioURI(path), configuration, conf);
    }

    public boolean supportsPath(String path, Configuration conf) {
        if (path == null) {
            return false;
        }
        return path.startsWith("glusterfs://");
    }
}

