/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.glusterfs;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class GlusterFSUnderFileSystem
extends HdfsUnderFileSystem {
    public static final String SCHEME = "glusterfs://";

    public GlusterFSUnderFileSystem(AlluxioURI uri, Object conf) {
        super(uri, conf);
    }

    public String getUnderFSType() {
        return "glusterfs";
    }

    protected void prepareConfiguration(String path, org.apache.hadoop.conf.Configuration hadoopConf) {
        if (path.startsWith(SCHEME)) {
            hadoopConf.set("fs.glusterfs.impl", Configuration.get((PropertyKey)PropertyKey.UNDERFS_GLUSTERFS_IMPL));
            hadoopConf.set("mapred.system.dir", Configuration.get((PropertyKey)PropertyKey.UNDERFS_GLUSTERFS_MR_DIR));
            hadoopConf.set("fs.glusterfs.volumes", Configuration.get((PropertyKey)PropertyKey.UNDERFS_GLUSTERFS_VOLUMES));
            hadoopConf.set("fs.glusterfs.volume.fuse." + Configuration.get((PropertyKey)PropertyKey.UNDERFS_GLUSTERFS_VOLUMES), Configuration.get((PropertyKey)PropertyKey.UNDERFS_GLUSTERFS_MOUNTS));
        } else {
            super.prepareConfiguration(path, hadoopConf);
        }
    }
}

