/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.AlluxioURI;
import alluxio.SyncInfo;
import alluxio.collections.Pair;
import alluxio.conf.PropertyKey;
import alluxio.retry.CountingRetry;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.AtomicFileOutputStream;
import alluxio.underfs.AtomicFileOutputStreamCallback;
import alluxio.underfs.ConsistentUnderFileSystem;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsAclProvider;
import alluxio.underfs.hdfs.HdfsActiveSyncProvider;
import alluxio.underfs.hdfs.HdfsPositionedUnderFileInputStream;
import alluxio.underfs.hdfs.HdfsUnderFileInputStream;
import alluxio.underfs.hdfs.HdfsUnderFileOutputStream;
import alluxio.underfs.hdfs.NoopHdfsAclProvider;
import alluxio.underfs.hdfs.NoopHdfsActiveSyncProvider;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.DeleteOptions;
import alluxio.underfs.options.FileLocationOptions;
import alluxio.underfs.options.GetFileStatusOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.CommonUtils;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class HdfsUnderFileSystem
extends ConsistentUnderFileSystem
implements AtomicFileOutputStreamCallback {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUnderFileSystem.class);
    private static final int MAX_TRY = 5;
    private static final String HDFS_USER = "";
    private static final String HDFS_ACL_PROVIDER_CLASS = "alluxio.underfs.hdfs.acl.SupportedHdfsAclProvider";
    private static final String HDFS_ACTIVESYNC_PROVIDER_CLASS = "alluxio.underfs.hdfs.activesync.SupportedHdfsActiveSyncProvider";
    private static final String HDFS_EC_MIN_VERSION = "3.0.0";
    private static final String HDFS_EC_CODEC_REGISTRY_CLASS = "org.apache.hadoop.io.erasurecode.CodecRegistry";
    private static final String JAVAX_WS_RS_CORE_MEDIA_TYPE = "javax.ws.rs.core.MediaType";
    private static final String HADOOP_AUTH_METHOD = "hadoop.security.authentication";
    private static final String KRB5_CONF_FILE = "java.security.krb5.conf";
    private static final String KRB_KEYTAB_LOGIN_AUTO_RENEW = "hadoop.kerberos.keytab.login.autorenewal.enabled";
    private static final String CHECKSUM_COMBINE_MODE = "dfs.checksum.combine.mode";
    private final LoadingCache<String, FileSystem> mUserFs;
    private final HdfsAclProvider mHdfsAclProvider;
    private HdfsActiveSyncProvider mHdfsActiveSyncer;

    public static HdfsUnderFileSystem createInstance(AlluxioURI ufsUri, UnderFileSystemConfiguration conf) {
        Configuration hdfsConf = HdfsUnderFileSystem.createConfiguration(conf);
        return new HdfsUnderFileSystem(ufsUri, conf, hdfsConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HdfsUnderFileSystem(AlluxioURI ufsUri, UnderFileSystemConfiguration conf, final Configuration hdfsConf) {
        super(ufsUri, conf);
        HdfsAclProvider hdfsAclProvider = new NoopHdfsAclProvider();
        try {
            Object o = Class.forName(HDFS_ACL_PROVIDER_CLASS).newInstance();
            if (o instanceof HdfsAclProvider) {
                hdfsAclProvider = (HdfsAclProvider)o;
            } else {
                LOG.warn("SupportedHdfsAclProvider is not instance of HdfsAclProvider. HDFS ACLs will not be supported.");
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot create SupportedHdfsAclProvider. HDFS ACLs is not supported, Please upgrade to an HDFS version > 2.4 to enable support for ACL");
            LOG.debug("Exception:", (Throwable)e);
        }
        this.mHdfsAclProvider = hdfsAclProvider;
        final Path path = new Path(ufsUri.toString());
        final ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(hdfsConf.getClassLoader());
            if (this.mUfsConf.isSet(PropertyKey.HADOOP_SECURITY_AUTHENTICATION)) {
                hdfsConf.set(HADOOP_AUTH_METHOD, this.mUfsConf.getString(PropertyKey.HADOOP_SECURITY_AUTHENTICATION));
            }
            if (this.mUfsConf.isSet(PropertyKey.HADOOP_KRB5_CONF_FILE)) {
                System.setProperty(KRB5_CONF_FILE, this.mUfsConf.getString(PropertyKey.HADOOP_KRB5_CONF_FILE));
            }
            if (this.mUfsConf.isSet(PropertyKey.HADOOP_KERBEROS_KEYTAB_LOGIN_AUTORENEWAL)) {
                hdfsConf.setBoolean(KRB_KEYTAB_LOGIN_AUTO_RENEW, this.mUfsConf.getBoolean(PropertyKey.HADOOP_KERBEROS_KEYTAB_LOGIN_AUTORENEWAL));
            }
            if (this.mUfsConf.isSet(PropertyKey.HADOOP_CHECKSUM_COMBINE_MODE)) {
                hdfsConf.set(CHECKSUM_COMBINE_MODE, this.mUfsConf.getString(PropertyKey.HADOOP_CHECKSUM_COMBINE_MODE));
            }
            UserGroupInformation.setConfiguration((Configuration)hdfsConf);
            if ("3.3.4".compareTo(HDFS_EC_MIN_VERSION) >= 0) {
                try {
                    Class.forName(HDFS_EC_CODEC_REGISTRY_CLASS);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Cannot initialize HDFS EC CodecRegistry. HDFS EC will not be supported:", (Throwable)e);
                }
            }
            if (StringUtils.equals((CharSequence)"hdfs", (CharSequence)ufsUri.getScheme())) {
                try {
                    Class.forName(JAVAX_WS_RS_CORE_MEDIA_TYPE);
                }
                catch (ClassNotFoundException e) {
                    LOG.warn("Cannot initialize javax.ws.rs.MediaType.", (Throwable)e);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        this.mUserFs = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, FileSystem>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public FileSystem load(String userKey) throws Exception {
                ClassLoader previousClassLoader = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(currentClassLoader);
                    FileSystem fileSystem = path.getFileSystem(hdfsConf);
                    return fileSystem;
                }
                finally {
                    Thread.currentThread().setContextClassLoader(previousClassLoader);
                }
            }
        });
        HdfsActiveSyncProvider hdfsActiveSyncProvider = new NoopHdfsActiveSyncProvider();
        try {
            Constructor<?> c = Class.forName(HDFS_ACTIVESYNC_PROVIDER_CLASS).getConstructor(URI.class, Configuration.class, UnderFileSystemConfiguration.class);
            Object o = c.newInstance(URI.create(ufsUri.toString()), hdfsConf, this.mUfsConf);
            if (o instanceof HdfsActiveSyncProvider) {
                hdfsActiveSyncProvider = (HdfsActiveSyncProvider)o;
                LOG.info("Successfully instantiated SupportedHdfsActiveSyncProvider");
            } else {
                LOG.warn("SupportedHdfsActiveSyncProvider is not instance of HdfsActiveSyncProvider. HDFS ActiveSync will not be supported.");
            }
        }
        catch (Exception e) {
            LOG.warn("Cannot create SupportedHdfsActiveSyncProvider. HDFS ActiveSync will not be supported. Please upgrade to an HDFS version > 2.6.1 to enable support for HDFS ActiveSync");
            LOG.debug("Exception:", (Throwable)e);
        }
        this.mHdfsActiveSyncer = hdfsActiveSyncProvider;
    }

    public String getUnderFSType() {
        return "hdfs";
    }

    public static Configuration createConfiguration(UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)conf, (Object)"conf");
        Configuration hdfsConf = new Configuration();
        for (String path : conf.getString(PropertyKey.UNDERFS_HDFS_CONFIGURATION).split(":")) {
            if (path.isEmpty()) continue;
            hdfsConf.addResource(new Path(path));
        }
        String ufsHdfsImpl = conf.getString(PropertyKey.UNDERFS_HDFS_IMPL);
        if (!StringUtils.isEmpty((CharSequence)ufsHdfsImpl)) {
            hdfsConf.set("fs.hdfs.impl", ufsHdfsImpl);
        }
        hdfsConf.set("fs.hdfs.impl.disable.cache", System.getProperty("fs.hdfs.impl.disable.cache", "true"));
        for (Map.Entry entry : conf.getMountSpecificConf().entrySet()) {
            hdfsConf.set((String)entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
        }
        return hdfsConf;
    }

    public void cleanup() {
    }

    public void close() {
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (!options.isEnsureAtomic()) {
            return this.createDirect(path, options);
        }
        return new AtomicFileOutputStream(path, (AtomicFileOutputStreamCallback)this, options);
    }

    public OutputStream createDirect(String path, CreateOptions options) throws IOException {
        IOException te = null;
        FileSystem hdfs = this.getFs();
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                HdfsUnderFileOutputStream outputStream = new HdfsUnderFileOutputStream(hdfs, path, FileSystem.create((FileSystem)hdfs, (Path)new Path(path), (FsPermission)new FsPermission(options.getMode().toShort())));
                if (options.getAcl() != null) {
                    this.setAclEntries(path, options.getAcl().getEntries());
                }
                return outputStream;
            }
            catch (IOException e) {
                LOG.warn("Attempt count {} : {} ", (Object)retryPolicy.getAttemptCount(), (Object)e.toString());
                te = e;
            }
        }
        throw te;
    }

    public boolean deleteDirectory(String path, DeleteOptions options) throws IOException {
        return this.isDirectory(path) && this.delete(path, options.isRecursive());
    }

    public boolean deleteFile(String path) throws IOException {
        return this.isFile(path) && this.delete(path, false);
    }

    public boolean exists(String path) throws IOException {
        FileSystem hdfs = this.getFs();
        return hdfs.exists(new Path(path));
    }

    public Pair<AccessControlList, DefaultAccessControlList> getAclPair(String path) throws IOException {
        return this.mHdfsAclProvider.getAcl(this.getFs(), path);
    }

    public void setAclEntries(String path, List<AclEntry> aclEntries) throws IOException {
        this.mHdfsAclProvider.setAclEntries(this.getFs(), path, aclEntries);
    }

    public long getBlockSizeByte(String path) throws IOException {
        Path tPath = new Path(path);
        FileSystem hdfs = this.getFs();
        if (!hdfs.exists(tPath)) {
            throw new FileNotFoundException(path);
        }
        FileStatus fs = hdfs.getFileStatus(tPath);
        return fs.getBlockSize();
    }

    public UfsDirectoryStatus getDirectoryStatus(String path) throws IOException {
        Path tPath = new Path(path);
        FileSystem hdfs = this.getFs();
        FileStatus fs = hdfs.getFileStatus(tPath);
        return new UfsDirectoryStatus(path, fs.getOwner(), fs.getGroup(), fs.getPermission().toShort(), Long.valueOf(fs.getModificationTime()));
    }

    public List<String> getFileLocations(String path) throws IOException {
        return this.getFileLocations(path, FileLocationOptions.defaults());
    }

    @Nullable
    public List<String> getFileLocations(String path, FileLocationOptions options) throws IOException {
        if (this.mUfsConf.getBoolean(PropertyKey.UNDERFS_HDFS_REMOTE)) {
            return null;
        }
        FileSystem hdfs = this.getFs();
        ArrayList<String> ret = new ArrayList<String>();
        try {
            FileStatus fileStatus = new FileStatus(0L, false, 0, 0L, 0L, 0L, null, null, null, new Path(path));
            BlockLocation[] bLocations = hdfs.getFileBlockLocations(fileStatus, options.getOffset(), 1L);
            if (bLocations.length > 0) {
                String[] names = bLocations[0].getHosts();
                Collections.addAll(ret, names);
            }
        }
        catch (IOException e) {
            LOG.debug("Unable to get file location for {}", (Object)path, (Object)e);
        }
        return ret;
    }

    public UfsFileStatus getFileStatus(String path, GetFileStatusOptions options) throws IOException {
        Path tPath = new Path(path);
        FileSystem hdfs = this.getFs();
        FileStatus fs = hdfs.getFileStatus(tPath);
        String contentHash = options.isIncludeRealContentHash() ? Base64.encodeBase64String((byte[])hdfs.getFileChecksum(tPath).getBytes()) : UnderFileSystemUtils.approximateContentHash((long)fs.getLen(), (long)fs.getModificationTime());
        return new UfsFileStatus(path, contentHash, fs.getLen(), Long.valueOf(fs.getModificationTime()), fs.getOwner(), fs.getGroup(), fs.getPermission().toShort(), fs.getBlockSize());
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        FileSystem hdfs = this.getFs();
        long space = -1L;
        if (hdfs instanceof DistributedFileSystem) {
            switch (type) {
                case SPACE_TOTAL: {
                    space = hdfs.getStatus().getCapacity();
                    break;
                }
                case SPACE_USED: {
                    space = hdfs.getStatus().getUsed();
                    break;
                }
                case SPACE_FREE: {
                    space = hdfs.getStatus().getRemaining();
                    break;
                }
                default: {
                    throw new IOException("Unknown space type: " + type);
                }
            }
        }
        return space;
    }

    public UfsStatus getStatus(String path) throws IOException {
        Path tPath = new Path(path);
        FileSystem hdfs = this.getFs();
        FileStatus fs = hdfs.getFileStatus(tPath);
        if (!fs.isDir()) {
            String contentHash = UnderFileSystemUtils.approximateContentHash((long)fs.getLen(), (long)fs.getModificationTime());
            return new UfsFileStatus(path, contentHash, fs.getLen(), Long.valueOf(fs.getModificationTime()), fs.getOwner(), fs.getGroup(), fs.getPermission().toShort(), fs.getBlockSize());
        }
        return new UfsDirectoryStatus(path, fs.getOwner(), fs.getGroup(), fs.getPermission().toShort(), Long.valueOf(fs.getModificationTime()));
    }

    public boolean isDirectory(String path) throws IOException {
        FileSystem hdfs = this.getFs();
        return hdfs.isDirectory(new Path(path));
    }

    public boolean isFile(String path) throws IOException {
        FileSystem hdfs = this.getFs();
        return hdfs.isFile(new Path(path));
    }

    @Nullable
    public UfsStatus[] listStatus(String path) throws IOException {
        FileStatus[] files = this.listStatusInternal(path);
        if (files == null) {
            return null;
        }
        UfsStatus[] rtn = new UfsStatus[files.length];
        int i = 0;
        for (FileStatus status : files) {
            UfsDirectoryStatus retStatus;
            if (!status.isDir()) {
                String contentHash = UnderFileSystemUtils.approximateContentHash((long)status.getLen(), (long)status.getModificationTime());
                retStatus = new UfsFileStatus(status.getPath().getName(), contentHash, status.getLen(), Long.valueOf(status.getModificationTime()), status.getOwner(), status.getGroup(), status.getPermission().toShort(), status.getBlockSize());
            } else {
                retStatus = new UfsDirectoryStatus(status.getPath().getName(), status.getOwner(), status.getGroup(), status.getPermission().toShort(), Long.valueOf(status.getModificationTime()));
            }
            rtn[i++] = retStatus;
        }
        return rtn;
    }

    public void connectFromMaster(String host) throws IOException {
        if (!this.mUfsConf.isSet(PropertyKey.MASTER_KEYTAB_KEY_FILE) || !this.mUfsConf.isSet(PropertyKey.MASTER_PRINCIPAL)) {
            return;
        }
        String masterKeytab = this.mUfsConf.getString(PropertyKey.MASTER_KEYTAB_KEY_FILE);
        String masterPrincipal = this.mUfsConf.getString(PropertyKey.MASTER_PRINCIPAL);
        this.login(PropertyKey.MASTER_KEYTAB_KEY_FILE, masterKeytab, PropertyKey.MASTER_PRINCIPAL, masterPrincipal, host);
    }

    public void connectFromWorker(String host) throws IOException {
        if (!this.mUfsConf.isSet(PropertyKey.WORKER_KEYTAB_FILE) || !this.mUfsConf.isSet(PropertyKey.WORKER_PRINCIPAL)) {
            return;
        }
        String workerKeytab = this.mUfsConf.getString(PropertyKey.WORKER_KEYTAB_FILE);
        String workerPrincipal = this.mUfsConf.getString(PropertyKey.WORKER_PRINCIPAL);
        this.login(PropertyKey.WORKER_KEYTAB_FILE, workerKeytab, PropertyKey.WORKER_PRINCIPAL, workerPrincipal, host);
    }

    private void login(PropertyKey keytabFileKey, String keytabFile, PropertyKey principalKey, String principal, String hostname) throws IOException {
        Configuration conf = new Configuration();
        conf.set(keytabFileKey.toString(), keytabFile);
        conf.set(principalKey.toString(), principal);
        SecurityUtil.login((Configuration)conf, (String)keytabFileKey.toString(), (String)principalKey.toString(), (String)hostname);
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        IOException te = null;
        FileSystem hdfs = this.getFs();
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                Path hdfsPath = new Path(path);
                if (hdfs.exists(hdfsPath)) {
                    LOG.debug("Trying to create existing directory at {}", (Object)path);
                    return false;
                }
                Stack<Path> dirsToMake = new Stack<Path>();
                dirsToMake.push(hdfsPath);
                Path parent = hdfsPath.getParent();
                while (!hdfs.exists(parent)) {
                    dirsToMake.push(parent);
                    parent = parent.getParent();
                }
                while (!dirsToMake.empty()) {
                    Path dirToMake = (Path)dirsToMake.pop();
                    if (!FileSystem.mkdirs((FileSystem)hdfs, (Path)dirToMake, (FsPermission)new FsPermission(options.getMode().toShort()))) {
                        return false;
                    }
                    try {
                        this.setOwner(dirToMake.toString(), options.getOwner(), options.getGroup());
                    }
                    catch (IOException e) {
                        LOG.warn("Failed to update the ufs dir ownership, default values will be used. " + e);
                    }
                }
                return true;
            }
            catch (IOException e) {
                LOG.warn("{} try to make directory for {} : {}", new Object[]{retryPolicy.getAttemptCount(), path, e.toString()});
                te = e;
            }
        }
        throw te;
    }

    private boolean isReadLocal(FileSystem fs, Path filePath, OpenOptions options) {
        String localHost = NetworkAddressUtils.getLocalHostName((int)((int)this.mUfsConf.getMs(PropertyKey.NETWORK_HOST_RESOLUTION_TIMEOUT_MS)));
        try {
            BlockLocation[] blockLocations = fs.getFileBlockLocations(filePath, options.getOffset(), options.getLength());
            if (blockLocations == null) {
                return true;
            }
            for (BlockLocation loc : blockLocations) {
                if (!Arrays.stream(loc.getHosts()).noneMatch(localHost::equals)) continue;
                return false;
            }
        }
        catch (IOException e) {
            return true;
        }
        return true;
    }

    public InputStream open(String path, OpenOptions options) throws IOException {
        boolean remote;
        IOException te = null;
        FileSystem hdfs = this.getFs();
        CountingRetry retryPolicy = new CountingRetry(5);
        DistributedFileSystem dfs = null;
        if (hdfs instanceof DistributedFileSystem) {
            dfs = (DistributedFileSystem)hdfs;
        }
        Path filePath = new Path(path);
        boolean bl = remote = options.getPositionShort() || this.mUfsConf.getBoolean(PropertyKey.UNDERFS_HDFS_REMOTE) || !this.isReadLocal(hdfs, filePath, options);
        while (retryPolicy.attempt()) {
            try {
                FSDataInputStream inputStream = hdfs.open(filePath);
                if (remote) {
                    LOG.debug("Using pread API to HDFS");
                    return new HdfsPositionedUnderFileInputStream(inputStream, options.getOffset());
                }
                try {
                    inputStream.seek(options.getOffset());
                }
                catch (IOException e) {
                    inputStream.close();
                    throw e;
                }
                LOG.debug("Using original API to HDFS");
                return new HdfsUnderFileInputStream(inputStream);
            }
            catch (IOException e) {
                LOG.debug("{} try to open {} : {}", new Object[]{retryPolicy.getAttemptCount(), path, e.toString()});
                te = e;
                if (!options.getRecoverFailedOpen() || dfs == null || !e.getMessage().toLowerCase().startsWith("cannot obtain block length for")) continue;
                try {
                    if (dfs.recoverLease(new Path(path))) {
                        LOG.warn("HDFS recoverLease-1 success for: {}", (Object)path);
                        continue;
                    }
                    CommonUtils.sleepMs((long)5000L);
                    if (dfs.recoverLease(new Path(path))) {
                        LOG.warn("HDFS recoverLease-2 success for: {}", (Object)path);
                        continue;
                    }
                    LOG.warn("HDFS recoverLease: path not closed: {}", (Object)path);
                }
                catch (IOException e1) {
                    LOG.warn("HDFS recoverLease failed for: {} error: {}", (Object)path, (Object)e1.getMessage());
                }
            }
        }
        if (te != null) {
            LOG.error("{} failed attempts to open \"{}\" with last error:", new Object[]{retryPolicy.getAttemptCount(), path, te});
            throw te;
        }
        throw new IllegalStateException("Exceeded the number of retry attempts with no exception");
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        if (!this.isDirectory(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a file", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public boolean renameFile(String src, String dst) throws IOException {
        if (!this.isFile(src)) {
            LOG.warn("Unable to rename {} to {} because source does not exist or is a directory", (Object)src, (Object)dst);
            return false;
        }
        return this.rename(src, dst);
    }

    public void setOwner(String path, String user, String group) throws IOException {
        if (user == null && group == null) {
            return;
        }
        FileSystem hdfs = this.getFs();
        try {
            FileStatus fileStatus = hdfs.getFileStatus(new Path(path));
            hdfs.setOwner(fileStatus.getPath(), user, group);
        }
        catch (IOException e) {
            LOG.debug("Exception: ", (Throwable)e);
            if (!this.mUfsConf.getBoolean(PropertyKey.UNDERFS_ALLOW_SET_OWNER_FAILURE)) {
                LOG.warn("Failed to set owner for {} with user: {}, group: {}: {}. Running Alluxio as superuser is required to modify ownership of local files", new Object[]{path, user, group, e.toString()});
                throw e;
            }
            LOG.warn("Failed to set owner for {} with user: {}, group: {}: {}. This failure is ignored but may cause permission inconsistency between Alluxio and local under file system", new Object[]{path, user, group, e.toString()});
        }
    }

    public void setMode(String path, short mode) throws IOException {
        FileSystem hdfs = this.getFs();
        try {
            FileStatus fileStatus = hdfs.getFileStatus(new Path(path));
            hdfs.setPermission(fileStatus.getPath(), new FsPermission(mode));
        }
        catch (IOException e) {
            LOG.warn("Fail to set permission for {} with perm {} : {}", new Object[]{path, mode, e.toString()});
            throw e;
        }
    }

    public boolean supportsFlush() {
        return true;
    }

    public boolean supportsActiveSync() {
        return !(this.mHdfsActiveSyncer instanceof NoopHdfsActiveSyncProvider);
    }

    public SyncInfo getActiveSyncInfo() {
        return this.mHdfsActiveSyncer.getActivitySyncInfo();
    }

    public boolean startActiveSyncPolling(long txId) throws IOException {
        return this.mHdfsActiveSyncer.startPolling(txId);
    }

    public boolean stopActiveSyncPolling() {
        return this.mHdfsActiveSyncer.stopPolling();
    }

    public void startSync(AlluxioURI ufsUri) {
        this.mHdfsActiveSyncer.startSync(ufsUri);
    }

    public void stopSync(AlluxioURI ufsUri) {
        this.mHdfsActiveSyncer.stopSync(ufsUri);
    }

    private boolean delete(String path, boolean recursive) throws IOException {
        IOException te = null;
        FileSystem hdfs = this.getFs();
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                return hdfs.delete(new Path(path), recursive);
            }
            catch (IOException e) {
                LOG.warn("Attempt count {} : {}", (Object)retryPolicy.getAttemptCount(), (Object)e.toString());
                te = e;
            }
        }
        throw te;
    }

    @Nullable
    private FileStatus[] listStatusInternal(String path) throws IOException {
        FileStatus[] files;
        FileSystem hdfs = this.getFs();
        Path thePath = new Path(path);
        try {
            files = hdfs.listStatus(thePath);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        if (files != null && files.length == 1 && files[0].getPath().toUri().getPath().equals(thePath.toUri().getPath())) {
            return null;
        }
        return files;
    }

    private boolean rename(String src, String dst) throws IOException {
        IOException te = null;
        FileSystem hdfs = this.getFs();
        CountingRetry retryPolicy = new CountingRetry(5);
        while (retryPolicy.attempt()) {
            try {
                return hdfs.rename(new Path(src), new Path(dst));
            }
            catch (IOException e) {
                LOG.warn("{} try to rename {} to {} : {}", new Object[]{retryPolicy.getAttemptCount(), src, dst, e.toString()});
                te = e;
            }
        }
        throw te;
    }

    public boolean isSeekable() {
        return true;
    }

    private FileSystem getFs() throws IOException {
        try {
            return (FileSystem)this.mUserFs.get((Object)HDFS_USER);
        }
        catch (ExecutionException e) {
            throw new IOException("Failed get FileSystem for " + this.mUri, e.getCause());
        }
    }
}

