/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.underfs.SeekableUnderFileInputStream;
import alluxio.underfs.hdfs.AlluxioHdfsException;
import alluxio.util.io.BufferUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.PositionedReadable;
import org.apache.hadoop.fs.Seekable;

public class HdfsPositionedUnderFileInputStream
extends SeekableUnderFileInputStream {
    @VisibleForTesting
    static final int SEQUENTIAL_READ_LIMIT = 3;
    @VisibleForTesting
    static final int MOVEMENT_LIMIT = 512;
    private long mPos;
    private int mSequentialReadCount;

    HdfsPositionedUnderFileInputStream(FSDataInputStream in, long pos) {
        super((InputStream)in);
        this.mPos = pos;
        this.mSequentialReadCount = 0;
    }

    public int available() throws IOException {
        if (this.mPos != ((FSDataInputStream)this.in).getPos()) {
            return 0;
        }
        return this.in.available();
    }

    public long getPos() {
        return this.mPos;
    }

    public int read() {
        byte[] buffer = new byte[1];
        int bytesRead = this.read(buffer);
        if (bytesRead > 0) {
            return BufferUtils.byteToInt((byte)buffer[0]);
        }
        Preconditions.checkArgument((bytesRead != 0 ? 1 : 0) != 0, (Object)"Expected a non-zero value if end of stream has not been reached");
        return bytesRead;
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] buffer, int offset, int length) {
        try {
            int bytesRead;
            if (this.isSequentialReadMode() && this.mPos != ((Seekable)this.in).getPos()) {
                ((Seekable)this.in).seek(this.mPos);
            }
            if ((bytesRead = this.mPos == ((Seekable)this.in).getPos() ? this.in.read(buffer, offset, length) : ((PositionedReadable)this.in).read(this.mPos, buffer, offset, length)) > 0) {
                this.mPos += (long)bytesRead;
                ++this.mSequentialReadCount;
            }
            return bytesRead;
        }
        catch (IOException e) {
            throw AlluxioHdfsException.from((IOException)e);
        }
    }

    private boolean isSequentialReadMode() {
        return this.mSequentialReadCount >= 3;
    }

    public void seek(long position) {
        if (position < this.mPos || position - this.mPos > 512L) {
            this.mSequentialReadCount = 0;
        }
        this.mPos = position;
    }

    public long skip(long n) {
        if (n <= 0L) {
            return 0L;
        }
        if (n > 512L) {
            this.mSequentialReadCount = 0;
        }
        this.mPos += n;
        return n;
    }

    public boolean markSupported() {
        return false;
    }
}

