/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.underfs.ContentHashable;
import alluxio.util.UnderFileSystemUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

@NotThreadSafe
public class HdfsUnderFileOutputStream
extends OutputStream
implements ContentHashable {
    private final FSDataOutputStream mOut;
    private final FileSystem mFs;
    private final String mPath;

    public HdfsUnderFileOutputStream(FileSystem fs, String path, FSDataOutputStream out) {
        this.mFs = fs;
        this.mPath = path;
        this.mOut = out;
    }

    @Override
    public void close() throws IOException {
        this.mOut.close();
    }

    @Override
    public void flush() throws IOException {
        this.mOut.hsync();
    }

    @Override
    public void write(int b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mOut.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mOut.write(b, off, len);
    }

    public Optional<String> getContentHash() throws IOException {
        FileStatus fs = this.mFs.getFileStatus(new Path(this.mPath));
        return Optional.of(UnderFileSystemUtils.approximateContentHash((long)fs.getLen(), (long)fs.getModificationTime()));
    }
}

