/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs.hdfs3;

import alluxio.underfs.UfsStatus;
import alluxio.underfs.hdfs.hdfs3.HdfsUnderFileSystemIntegrationTestBase;
import alluxio.underfs.options.ListOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.junit.Test;

public class HdfsUnderFileSystemIntegrationTest
extends HdfsUnderFileSystemIntegrationTestBase {
    @Test
    public void testWriteEmptyFile() throws Exception {
        this.writeEmptyFileTest();
    }

    @Test
    public void testWriteMultiBlockFileTest() throws Exception {
        this.writeMultiBlockFileTest("/test_file");
    }

    @Test(expected=IOException.class)
    public void testException() throws Exception {
        this.hdfsDownDuringUploadTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetAndGetXAttribute() throws Exception {
        String testFilePath = "/empty_file";
        OutputStream os = this.mUfs.create(testFilePath, this.getCreateOption());
        os.close();
        TestCase.assertEquals((long)0L, (long)this.mUfs.getStatus(testFilePath).asUfsFileStatus().getContentLength());
        try {
            String attrKey = "key1";
            String attrValue = "value1";
            this.mUfs.setAttribute(testFilePath, attrKey, attrValue.getBytes());
            String attrKey2 = "key2";
            String attrEmptyValue = "";
            this.mUfs.setAttribute(testFilePath, attrKey2, attrEmptyValue.getBytes());
            String attrEmptyKey = "";
            this.mUfs.setAttribute(testFilePath, attrEmptyKey, attrValue.getBytes());
            Map attrMap = this.mUfs.getAttributes(testFilePath);
            TestCase.assertEquals((int)attrMap.size(), (int)2);
            TestCase.assertEquals((String)((String)attrMap.get(attrKey)), (String)attrValue);
            TestCase.assertEquals((String)((String)attrMap.get(attrKey2)), (String)attrEmptyValue);
            Assert.assertFalse((boolean)attrMap.containsKey(attrEmptyKey));
        }
        finally {
            this.mUfs.deleteFile(testFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetDuplicatedKeyToXAttr() throws Exception {
        String testFilePath = "/dup_xattr_file";
        OutputStream os = this.mUfs.create(testFilePath, this.getCreateOption());
        os.close();
        TestCase.assertEquals((long)0L, (long)this.mUfs.getStatus(testFilePath).asUfsFileStatus().getContentLength());
        try {
            String attrKey = "key1";
            String attrValue1 = "value1";
            String attrValue2 = "value2";
            this.mUfs.setAttribute(testFilePath, attrKey, attrValue1.getBytes());
            this.mUfs.setAttribute(testFilePath, attrKey, attrValue2.getBytes());
            Map attrMap = this.mUfs.getAttributes(testFilePath);
            TestCase.assertEquals((int)attrMap.size(), (int)1);
            TestCase.assertEquals((String)((String)attrMap.get(attrKey)), (String)attrValue2);
        }
        finally {
            this.mUfs.deleteFile(testFilePath);
        }
    }

    @Test
    public void testListUfsStatusIterator() throws Exception {
        this.createDirectoryTest("/testRoot");
        this.createDirectoryTest("/testRoot/testDirectory1");
        this.createDirectoryTest("/testRoot/testDirectory2");
        this.createDirectoryTest("/testRoot/testDirectory2/testDirectory3");
        this.writeMultiBlockFileTest("/testRoot/testFileA");
        this.writeMultiBlockFileTest("/testRoot/testDirectory1/testFileB");
        this.writeMultiBlockFileTest("/testRoot/testFileC");
        this.writeMultiBlockFileTest("/testRoot/testDirectory2/testFileD");
        this.writeMultiBlockFileTest("/testRoot/testDirectory2/testDirectory3/testFileE");
        String ufsSchema = this.mUfs.getFs().getUri().toString();
        this.testListPath(ufsSchema + "/testRoot");
        this.testListPath(ufsSchema + "/testRoot/");
        this.testListPath(ufsSchema + "/testRoot/testDirectory2");
        this.testListPath(ufsSchema + "/testRoot/testDirectory2/");
        this.testListPath(ufsSchema + "/testRoot/testDirectory2/testFileB");
        this.testListPath(ufsSchema + "/");
        this.testListPath("/testRoot");
        this.testListPath("/testRoot/");
        this.testListPath("/testRoot/testDirectory2");
        this.testListPath("/testRoot/testDirectory2/");
        this.testListPath("/testRoot/testDirectory2/testFileB");
        this.testListPath("/");
        Iterator iterator = this.mUfs.listStatusIterable("/testRoot", ListOptions.defaults(), null, 1000);
        ArrayList<UfsStatus> iteratorListRes = new ArrayList<UfsStatus>();
        while (iterator.hasNext()) {
            UfsStatus ufsStatus = (UfsStatus)iterator.next();
            iteratorListRes.add(ufsStatus);
        }
        TestCase.assertEquals((int)8, (int)iteratorListRes.size());
        TestCase.assertEquals((String)"testDirectory1", (String)((UfsStatus)iteratorListRes.get(0)).getName());
        TestCase.assertEquals((String)"testDirectory2", (String)((UfsStatus)iteratorListRes.get(1)).getName());
        TestCase.assertEquals((String)"testFileA", (String)((UfsStatus)iteratorListRes.get(2)).getName());
        TestCase.assertEquals((String)"testFileC", (String)((UfsStatus)iteratorListRes.get(3)).getName());
        TestCase.assertEquals((String)"testDirectory1/testFileB", (String)((UfsStatus)iteratorListRes.get(4)).getName());
        TestCase.assertEquals((String)"testDirectory2/testDirectory3", (String)((UfsStatus)iteratorListRes.get(5)).getName());
        TestCase.assertEquals((String)"testDirectory2/testFileD", (String)((UfsStatus)iteratorListRes.get(6)).getName());
        TestCase.assertEquals((String)"testDirectory2/testDirectory3/testFileE", (String)((UfsStatus)iteratorListRes.get(7)).getName());
    }

    private void testListPath(String path) throws IOException {
        Iterator iterator = this.mUfs.listStatusIterable(path, ListOptions.defaults(), null, 1000);
        List<Object> fullListRes = null;
        UfsStatus[] fullListResArray = this.mUfs.listStatus(path, ListOptions.defaults().setRecursive(true));
        fullListRes = fullListResArray == null ? Collections.emptyList() : Arrays.asList(fullListResArray);
        ArrayList<UfsStatus> iteratorListRes = new ArrayList<UfsStatus>();
        while (iterator.hasNext()) {
            UfsStatus ufsStatus = (UfsStatus)iterator.next();
            iteratorListRes.add(ufsStatus);
        }
        TestCase.assertEquals((int)fullListRes.size(), (int)iteratorListRes.size());
        for (int i = 0; i < fullListRes.size(); ++i) {
            UfsStatus fullListUfsStatus = (UfsStatus)fullListRes.get(i);
            UfsStatus iteratorListUfsStatus = (UfsStatus)iteratorListRes.get(i);
            TestCase.assertEquals((String)fullListUfsStatus.getName(), (String)iteratorListUfsStatus.getName());
            TestCase.assertEquals((String)fullListUfsStatus.getGroup(), (String)iteratorListUfsStatus.getGroup());
            TestCase.assertEquals((String)fullListUfsStatus.getOwner(), (String)iteratorListUfsStatus.getOwner());
            TestCase.assertEquals((short)fullListUfsStatus.getMode(), (short)iteratorListUfsStatus.getMode());
            TestCase.assertEquals((boolean)fullListUfsStatus.isDirectory(), (boolean)iteratorListUfsStatus.isDirectory());
            TestCase.assertEquals((boolean)fullListUfsStatus.isFile(), (boolean)iteratorListUfsStatus.isFile());
        }
    }
}

