/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs.hdfs3;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TemporaryFolder;

public class HdfsUnderFileSystemIntegrationTestBase {
    @Rule
    public TemporaryFolder mTemp = new TemporaryFolder();
    protected final org.apache.hadoop.conf.Configuration mHdfsConfiguration = new org.apache.hadoop.conf.Configuration();
    protected MiniDFSCluster mCluster;
    protected HdfsUnderFileSystem mUfs;
    private static final int BLOCK_SIZE = 0x100000;

    @Before
    public void before() throws IOException {
        this.mHdfsConfiguration.set("dfs.name.dir", this.mTemp.newFolder("nn").getAbsolutePath());
        this.mHdfsConfiguration.set("dfs.data.dir", this.mTemp.newFolder("dn").getAbsolutePath());
        this.mHdfsConfiguration.setInt("dfs.block.size", 0x100000);
        this.mCluster = new MiniDFSCluster.Builder(this.mHdfsConfiguration).enableManagedDfsDirsRedundancy(false).manageDataDfsDirs(false).manageNameDfsDirs(false).numDataNodes(1).build();
        UnderFileSystemConfiguration ufsConf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global());
        this.setConfiguration();
        this.mUfs = this.createUfs(ufsConf);
    }

    @After
    public void after() {
        if (this.mCluster != null) {
            this.mCluster.close();
        }
        if (this.mUfs != null) {
            this.mUfs.close();
        }
    }

    protected void writeMultiBlockFileTest(String testFilePath) throws IOException {
        int fileLength = 0x1000001;
        int numHdfsBlocks = (fileLength - 1) / 0x100000 + 1;
        RandomStringGenerator randomStringGenerator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build();
        String fileContentToWrite = randomStringGenerator.generate(fileLength);
        OutputStream os = this.mUfs.create(testFilePath, this.getCreateOption());
        os.write(fileContentToWrite.getBytes());
        os.close();
        InputStream is = this.mUfs.open(testFilePath);
        String readFileContent = IOUtils.toString((InputStream)is);
        Assert.assertEquals((Object)fileContentToWrite, (Object)readFileContent);
        TestCase.assertEquals((long)fileLength, (long)this.mUfs.getStatus(testFilePath).asUfsFileStatus().getContentLength());
        FileStatus status = this.mUfs.getFs().getFileStatus(new Path(testFilePath));
        TestCase.assertEquals((int)numHdfsBlocks, (int)this.mUfs.getFs().getFileBlockLocations(status, 0L, status.getLen()).length);
    }

    protected void createDirectoryTest(String dirPath) throws IOException {
        this.mUfs.mkdirs(dirPath);
    }

    protected void writeEmptyFileTest() throws IOException {
        String testFilePath = "/empty_file";
        OutputStream os = this.mUfs.create(testFilePath, this.getCreateOption());
        os.close();
        TestCase.assertEquals((long)0L, (long)this.mUfs.getStatus(testFilePath).asUfsFileStatus().getContentLength());
    }

    protected void hdfsDownDuringUploadTest() throws Exception {
        String testFilePath = "/test_file";
        RandomStringGenerator randomStringGenerator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build();
        String oneBlockFileContent = randomStringGenerator.generate(0x100000);
        OutputStream os = this.mUfs.create(testFilePath, this.getCreateOption());
        os.write(oneBlockFileContent.getBytes());
        os.write(oneBlockFileContent.getBytes());
        this.mCluster.stopDataNode(0);
        os.write(oneBlockFileContent.getBytes());
        os.close();
    }

    protected HdfsUnderFileSystem createUfs(UnderFileSystemConfiguration ufsConf) {
        return new HdfsUnderFileSystem(new AlluxioURI("/"), ufsConf, this.mHdfsConfiguration){

            public FileSystem getFs() throws IOException {
                return HdfsUnderFileSystemIntegrationTestBase.this.mCluster.getFileSystem();
            }
        };
    }

    protected void setConfiguration() {
    }

    protected CreateOptions getCreateOption() {
        return CreateOptions.defaults((AlluxioConfiguration)Configuration.global());
    }
}

