/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.AlluxioURI;
import alluxio.collections.Pair;
import alluxio.underfs.UfsDirectoryStatus;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.util.UnderFileSystemUtils;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUfsStatusIterator
implements Iterator<UfsStatus> {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUfsStatusIterator.class);
    private final FileSystem mFs;
    private final String mUfsSchemaUri;
    private final AlluxioURI mPathToList;
    private LinkedList<Pair<String, UfsStatus>> mDirPathsToProcess = new LinkedList();
    private RemoteIterator<FileStatus> mHdfsRemoteIterator;

    public HdfsUfsStatusIterator(String pathToList, FileSystem fs) {
        this.mFs = fs;
        this.mUfsSchemaUri = this.mFs.getUri().toString();
        this.mPathToList = new AlluxioURI(pathToList);
        this.initQueue(pathToList);
    }

    private void initQueue(String path) {
        try {
            Path thePath = new Path(path);
            this.mHdfsRemoteIterator = this.mFs.listStatusIterator(thePath);
        }
        catch (IOException e) {
            LOG.error("Failed to list the path {}", (Object)path, (Object)e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            if (this.mHdfsRemoteIterator == null) {
                return false;
            }
            if (this.mHdfsRemoteIterator.hasNext()) {
                return true;
            }
            if (this.mDirPathsToProcess.isEmpty()) {
                return false;
            }
            while (!this.mDirPathsToProcess.isEmpty()) {
                Pair<String, UfsStatus> dir = this.mDirPathsToProcess.removeFirst();
                String path = (String)dir.getFirst();
                this.mHdfsRemoteIterator = this.mFs.listStatusIterator(new Path(path));
                if (!this.mHdfsRemoteIterator.hasNext()) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UfsStatus next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            UfsDirectoryStatus ufsStatus;
            FileStatus fileStatus = (FileStatus)this.mHdfsRemoteIterator.next();
            Path path = fileStatus.getPath();
            if (fileStatus.isDirectory()) {
                String relativePath = this.extractRelativePath(path.toUri().getPath());
                ufsStatus = new UfsDirectoryStatus(relativePath, fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPermission().toShort(), Long.valueOf(fileStatus.getModificationTime()));
                ufsStatus.setUfsFullPath(this.mPathToList.join(ufsStatus.getName()));
                this.mDirPathsToProcess.addLast((Pair<String, UfsStatus>)new Pair((Object)path.toString(), (Object)ufsStatus));
            } else {
                String contentHash = UnderFileSystemUtils.approximateContentHash((long)fileStatus.getLen(), (long)fileStatus.getModificationTime());
                String relativePath = this.extractRelativePath(path.toUri().getPath());
                ufsStatus = new UfsFileStatus(relativePath, contentHash, fileStatus.getLen(), Long.valueOf(fileStatus.getModificationTime()), fileStatus.getOwner(), fileStatus.getGroup(), fileStatus.getPermission().toShort(), fileStatus.getBlockSize());
                ufsStatus.setUfsFullPath(this.mPathToList.join(ufsStatus.getName()));
            }
            return ufsStatus;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String extractRelativePath(String fullPath) {
        String fullPathWithoutSchema = this.trimPathPrefix(this.mUfsSchemaUri, fullPath);
        String pathToListWithoutSchema = this.trimPathPrefix(this.mUfsSchemaUri, this.mPathToList.toString());
        if (!pathToListWithoutSchema.startsWith("/")) {
            pathToListWithoutSchema = "/" + pathToListWithoutSchema;
        }
        return this.trimPathPrefix(pathToListWithoutSchema, fullPathWithoutSchema);
    }

    private String trimPathPrefix(String prefix, String path) {
        if (path.startsWith(prefix)) {
            if (prefix.endsWith("/")) {
                return path.substring(prefix.length());
            }
            return path.substring(prefix.length() + 1);
        }
        return path;
    }
}

