/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import java.util.regex.Pattern;
import javax.annotation.Nullable;

public enum HdfsVersion {
    HADOOP_1_0("hadoop-1.0", "(hadoop-?1\\.0(\\.(\\d+))?|1\\.0(\\.(\\d+)(-.*)?)?)"),
    HADOOP_1_2("hadoop-1.2", "(hadoop-?1\\.2(\\.(\\d+))?|1\\.2(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_2("hadoop-2.2", "(hadoop-?2\\.2(\\.(\\d+))?|2\\.2(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_3("hadoop-2.3", "(hadoop-?2\\.3(\\.(\\d+))?|2\\.3(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_4("hadoop-2.4", "(hadoop-?2\\.4(\\.(\\d+))?|2\\.4(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_5("hadoop-2.5", "(hadoop-?2\\.5(\\.(\\d+))?|2\\.5(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_6("hadoop-2.6", "(hadoop-?2\\.6(\\.(\\d+))?|2\\.6(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_7("hadoop-2.7", "(hadoop-?2\\.7(\\.(\\d+))?|2\\.7(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_8("hadoop-2.8", "(hadoop-?2\\.8(\\.(\\d+))?|2\\.8(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_9("hadoop-2.9", "(hadoop-?2\\.9(\\.(\\d+))?|2\\.9(\\.(\\d+)(-.*)?)?)"),
    HADOOP_2_10("hadoop-2.10", "(hadoop-?2\\.10(\\.(\\d+))?|2\\.10(\\.(\\d+)(-.*)?)?)"),
    HADOOP_3_0("hadoop-3.0", "(hadoop-?3\\.0(\\.(\\d+))?|3\\.0(\\.(\\d+)(-.*)?)?)"),
    HADOOP_3_1("hadoop-3.1", "(hadoop-?3\\.1(\\.(\\d+))?|3\\.1(\\.(\\d+)(-.*)?)?)"),
    HADOOP_3_2("hadoop-3.2", "(hadoop-?3\\.2(\\.(\\d+))?|3\\.2(\\.(\\d+)(-.*)?)?)"),
    HADOOP_3_3("hadoop-3.3", "(hadoop-?3\\.3(\\.(\\d+))?|3\\.3(\\.(\\d+)(-.*)?)?)");

    private final String mCanonicalVersion;
    private final Pattern mVersionPattern;

    private HdfsVersion(String canonicalVersion, String versionPattern) {
        this.mCanonicalVersion = canonicalVersion;
        this.mVersionPattern = Pattern.compile(versionPattern);
    }

    @Nullable
    public static HdfsVersion find(String versionString) {
        for (HdfsVersion version : HdfsVersion.values()) {
            if (!version.mVersionPattern.matcher(versionString).matches()) continue;
            return version;
        }
        return null;
    }

    public static boolean matches(String versionA, String versionB) {
        if (versionA.equals(versionB)) {
            return true;
        }
        return HdfsVersion.find(versionA) != null && HdfsVersion.find(versionA) == HdfsVersion.find(versionB);
    }

    public String getCanonicalVersion() {
        return this.mCanonicalVersion;
    }
}

