/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs.acl;

import alluxio.collections.Pair;
import alluxio.security.authorization.AccessControlList;
import alluxio.security.authorization.AclAction;
import alluxio.security.authorization.AclEntry;
import alluxio.security.authorization.AclEntryType;
import alluxio.security.authorization.DefaultAccessControlList;
import alluxio.underfs.hdfs.HdfsAclProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclEntryScope;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.protocol.AclException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SupportedHdfsAclProvider
implements HdfsAclProvider {
    private static final Logger LOG = LoggerFactory.getLogger(SupportedHdfsAclProvider.class);

    @Override
    public Pair<AccessControlList, DefaultAccessControlList> getAcl(FileSystem hdfs, String path) throws IOException {
        AclStatus hdfsAcl;
        Path filePath = new Path(path);
        boolean isDir = hdfs.isDirectory(filePath);
        try {
            hdfsAcl = hdfs.getAclStatus(filePath);
        }
        catch (AclException e) {
            return new Pair(null, null);
        }
        AccessControlList acl = new AccessControlList();
        DefaultAccessControlList defaultAcl = new DefaultAccessControlList();
        acl.setOwningUser(hdfsAcl.getOwner().intern());
        acl.setOwningGroup(hdfsAcl.getGroup().intern());
        defaultAcl.setOwningUser(hdfsAcl.getOwner());
        defaultAcl.setOwningGroup(hdfsAcl.getGroup());
        for (org.apache.hadoop.fs.permission.AclEntry entry : hdfsAcl.getEntries()) {
            AclEntry.Builder builder = new AclEntry.Builder();
            builder.setType(this.getAclEntryType(entry));
            builder.setSubject(entry.getName() == null ? "" : entry.getName());
            FsAction permission = entry.getPermission();
            if (permission.implies(FsAction.READ)) {
                builder.addAction(AclAction.READ);
            } else if (permission.implies(FsAction.WRITE)) {
                builder.addAction(AclAction.WRITE);
            } else if (permission.implies(FsAction.EXECUTE)) {
                builder.addAction(AclAction.EXECUTE);
            }
            if (entry.getScope().equals((Object)AclEntryScope.ACCESS)) {
                acl.setEntry(builder.build());
                continue;
            }
            defaultAcl.setEntry(builder.build());
        }
        if (isDir) {
            return new Pair((Object)acl, (Object)defaultAcl);
        }
        return new Pair((Object)acl, null);
    }

    @Override
    public void setAclEntries(FileSystem hdfs, String path, List<AclEntry> aclEntries) throws IOException {
        ArrayList<org.apache.hadoop.fs.permission.AclEntry> aclSpecs = new ArrayList<org.apache.hadoop.fs.permission.AclEntry>();
        for (AclEntry entry : aclEntries) {
            org.apache.hadoop.fs.permission.AclEntry hdfsAclEntry = this.getHdfsAclEntry(entry);
            aclSpecs.add(hdfsAclEntry);
        }
        try {
            hdfs.setAcl(new Path(path), aclSpecs);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private org.apache.hadoop.fs.permission.AclEntry getHdfsAclEntry(AclEntry entry) throws IOException {
        AclEntry.Builder builder = new AclEntry.Builder();
        if (entry.getType() != AclEntryType.OWNING_USER && entry.getType() != AclEntryType.OWNING_GROUP) {
            builder.setName(entry.getSubject());
        }
        builder.setScope(entry.isDefault() ? AclEntryScope.DEFAULT : AclEntryScope.ACCESS);
        builder.setType(this.getHdfsAclEntryType(entry));
        FsAction permission = FsAction.getFsAction((String)entry.getActions().toCliString());
        builder.setPermission(permission);
        return builder.build();
    }

    private org.apache.hadoop.fs.permission.AclEntryType getHdfsAclEntryType(AclEntry aclEntry) throws IOException {
        switch (aclEntry.getType()) {
            case OWNING_USER: 
            case NAMED_USER: {
                return org.apache.hadoop.fs.permission.AclEntryType.USER;
            }
            case OWNING_GROUP: 
            case NAMED_GROUP: {
                return org.apache.hadoop.fs.permission.AclEntryType.GROUP;
            }
            case MASK: {
                return org.apache.hadoop.fs.permission.AclEntryType.MASK;
            }
            case OTHER: {
                return org.apache.hadoop.fs.permission.AclEntryType.OTHER;
            }
        }
        throw new IOException("Unknown Alluxio ACL entry type: " + aclEntry.getType());
    }

    private AclEntryType getAclEntryType(org.apache.hadoop.fs.permission.AclEntry entry) throws IOException {
        switch (entry.getType()) {
            case USER: {
                return entry.getName() == null || entry.getName().isEmpty() ? AclEntryType.OWNING_USER : AclEntryType.NAMED_USER;
            }
            case GROUP: {
                return entry.getName() == null || entry.getName().isEmpty() ? AclEntryType.OWNING_GROUP : AclEntryType.NAMED_GROUP;
            }
            case MASK: {
                return AclEntryType.MASK;
            }
            case OTHER: {
                return AclEntryType.OTHER;
            }
        }
        throw new IOException("Unknown HDFS ACL entry type: " + entry.getType());
    }
}

