/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.hdfs;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.Configuration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.SeekableUnderFileInputStream;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.hdfs.HdfsUnderFileSystem;
import alluxio.underfs.hdfs.PreadSeekableStream;
import alluxio.underfs.options.OpenOptions;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.reflect.Whitebox;

public final class HdfsUnderFileSystemTest {
    private HdfsUnderFileSystem mHdfsUnderFileSystem;
    @Rule
    public TemporaryFolder mTemporaryFolder = new TemporaryFolder();

    @Before
    public void before() throws Exception {
        UnderFileSystemConfiguration conf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global()).createMountSpecificConf((Map)ImmutableMap.of((Object)"hadoop.security.group.mapping", (Object)"org.apache.hadoop.security.ShellBasedUnixGroupsMapping", (Object)"fs.hdfs.impl", (Object)PropertyKey.UNDERFS_HDFS_IMPL.getDefaultValue()));
        this.mHdfsUnderFileSystem = HdfsUnderFileSystem.createInstance((AlluxioURI)new AlluxioURI(this.mTemporaryFolder.getRoot().getAbsolutePath()), (UnderFileSystemConfiguration)conf);
    }

    @Test
    public void getUnderFSType() throws Exception {
        Assert.assertEquals((Object)"hdfs", (Object)this.mHdfsUnderFileSystem.getUnderFSType());
    }

    @Test
    public void prepareConfiguration() throws Exception {
        UnderFileSystemConfiguration ufsConf = UnderFileSystemConfiguration.defaults((AlluxioConfiguration)Configuration.global());
        org.apache.hadoop.conf.Configuration conf = HdfsUnderFileSystem.createConfiguration((UnderFileSystemConfiguration)ufsConf);
        Assert.assertEquals((Object)ufsConf.get(PropertyKey.UNDERFS_HDFS_IMPL), (Object)conf.get("fs.hdfs.impl"));
        Assert.assertTrue((boolean)conf.getBoolean("fs.hdfs.impl.disable.cache", false));
    }

    private void checkDataValid(int data, int index) {
        Assert.assertEquals((long)((byte)index), (long)((byte)data));
    }

    @Test
    public void verifyPread() throws Exception {
        File file = this.mTemporaryFolder.newFile("test.txt");
        byte[] data = new byte[2048];
        for (int i = 0; i < 2048; ++i) {
            data[i] = (byte)i;
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        SeekableUnderFileInputStream in = (SeekableUnderFileInputStream)this.mHdfsUnderFileSystem.open(file.getAbsolutePath(), OpenOptions.defaults().setPositionShort(true));
        FSDataInputStream dataInput = (FSDataInputStream)Whitebox.getInternalState((Object)in, (String)"in");
        PreadSeekableStream stream = new PreadSeekableStream((InputStream)dataInput);
        PreadSeekableStream spyStream = (PreadSeekableStream)Mockito.spy((Object)stream);
        Whitebox.setInternalState((Object)in, (String)"in", (Object)spyStream);
        int readPos = 0;
        this.checkDataValid(in.read(), readPos++);
        this.checkDataValid(in.read(), readPos++);
        this.checkDataValid(in.read(), readPos++);
        this.checkDataValid(in.read(), readPos++);
        in.skip(2L);
        in.skip(2L);
        readPos += 4;
        this.checkDataValid(in.read(), readPos++);
        in.skip(2L);
        readPos += 2;
        this.checkDataValid(in.read(), readPos++);
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.never())).read(ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)6))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        in.skip(513L);
        readPos += 513;
        for (int i = 0; i < 3; ++i) {
            this.checkDataValid(in.read(), readPos++);
        }
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)3))).read(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)6))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        this.checkDataValid(in.read(), readPos++);
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)3))).read(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)7))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        in.seek(1536L);
        readPos = 1536;
        this.checkDataValid(in.read(), readPos++);
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)4))).read(ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        ((PreadSeekableStream)Mockito.verify((Object)spyStream, (VerificationMode)Mockito.times((int)7))).read((byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        in.close();
    }
}

