/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.kodo;

import alluxio.exception.status.NotFoundException;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class KodoClient {
    private Auth mAuth;
    private BucketManager mBucketManager;
    private UploadManager mUploadManager;
    private OkHttpClient mOkHttpClient;
    private String mBucketName;
    private String mDownloadHost;
    private String mEndPoint;

    public KodoClient(Auth auth, String bucketName, String downloadHost, String endPoint, Configuration cfg, OkHttpClient okHttpClient) {
        this.mAuth = auth;
        this.mBucketName = bucketName;
        this.mEndPoint = endPoint;
        this.mDownloadHost = downloadHost;
        this.mBucketManager = new BucketManager(this.mAuth, cfg);
        this.mUploadManager = new UploadManager(cfg);
        this.mOkHttpClient = okHttpClient;
    }

    public String getBucketName() {
        return this.mBucketName;
    }

    public FileInfo getFileInfo(String key) throws QiniuException {
        return this.mBucketManager.stat(this.mBucketName, key);
    }

    public InputStream getObject(String key, long startPos, long endPos, long contentLength) throws IOException {
        String baseUrl = String.format("http://%s/%s", this.mDownloadHost, key);
        String privateUrl = this.mAuth.privateDownloadUrl(baseUrl);
        URL url = new URL(privateUrl);
        String objectUrl = String.format("http://%s/%s?%s", this.mEndPoint, key, url.getQuery());
        Request request = new Request.Builder().url(objectUrl).addHeader("Range", "bytes=" + String.valueOf(startPos) + "-" + String.valueOf(endPos < contentLength ? endPos - 1L : contentLength - 1L)).addHeader("Host", this.mDownloadHost).get().build();
        Response response = this.mOkHttpClient.newCall(request).execute();
        if (response.code() == 404) {
            throw new NotFoundException("Qiniu kodo: " + response.message());
        }
        if (response.code() != 200 && response.code() != 206) {
            throw new IOException(String.format("Qiniu kodo:get object failed errcode:%d,errmsg:%s", response.code(), response.message()));
        }
        return response.body().byteStream();
    }

    public void uploadFile(String Key, File File2) throws QiniuException {
        com.qiniu.http.Response response = this.mUploadManager.put(File2, Key, this.mAuth.uploadToken(this.mBucketName, Key));
        response.close();
    }

    public void copyObject(String src, String dst) throws QiniuException {
        this.mBucketManager.copy(this.mBucketName, src, this.mBucketName, dst);
    }

    public void createEmptyObject(String key) throws QiniuException {
        com.qiniu.http.Response response = this.mUploadManager.put(new byte[0], key, this.mAuth.uploadToken(this.mBucketName, key));
        response.close();
    }

    public void deleteObject(String key) throws QiniuException {
        com.qiniu.http.Response response = this.mBucketManager.delete(this.mBucketName, key);
        response.close();
    }

    public FileListing listFiles(String prefix, String marker, int limit, String delimiter) throws QiniuException {
        return this.mBucketManager.listFiles(this.mBucketName, prefix, marker, limit, delimiter);
    }
}

