/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.kodo;

import alluxio.AlluxioURI;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.kodo.KodoClient;
import alluxio.underfs.kodo.KodoInputStream;
import alluxio.underfs.kodo.KodoOutputStream;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.storage.model.FileListing;
import com.qiniu.util.Auth;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodoUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(KodoUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = "/";
    private final KodoClient mKodoClinet;

    protected KodoUnderFileSystem(AlluxioURI uri, KodoClient kodoclient, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mKodoClinet = kodoclient;
    }

    protected static KodoUnderFileSystem creatInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) {
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.KODO_ACCESS_KEY), (String)"Property %s is required to connect to Kodo", (Object)PropertyKey.KODO_ACCESS_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.KODO_SECRET_KEY), (String)"Property %s is required to connect to Kodo", (Object)PropertyKey.KODO_SECRET_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.KODO_DOWNLOAD_HOST), (String)"Property %s is required to connect to Kodo", (Object)PropertyKey.KODO_DOWNLOAD_HOST);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.KODO_ENDPOINT), (String)"Property %s is required to connect to Kodo", (Object)PropertyKey.KODO_ENDPOINT);
        String accessKey = conf.get(PropertyKey.KODO_ACCESS_KEY);
        String secretKey = conf.get(PropertyKey.KODO_SECRET_KEY);
        String endPoint = conf.get(PropertyKey.KODO_ENDPOINT);
        String souceHost = conf.get(PropertyKey.KODO_DOWNLOAD_HOST);
        Auth auth = Auth.create((String)accessKey, (String)secretKey);
        Configuration configuration = new Configuration();
        OkHttpClient.Builder okHttpBuilder = KodoUnderFileSystem.initializeKodoClientConfig(conf);
        OkHttpClient okHttpClient = okHttpBuilder.build();
        KodoClient kodoClient = new KodoClient(auth, bucketName, souceHost, endPoint, configuration, okHttpClient);
        return new KodoUnderFileSystem(uri, kodoClient, conf);
    }

    private static OkHttpClient.Builder initializeKodoClientConfig(UnderFileSystemConfiguration conf) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(conf.getInt(PropertyKey.UNDERFS_KODO_REQUESTS_MAX));
        builder.connectTimeout(conf.getMs(PropertyKey.UNDERFS_KODO_CONNECT_TIMEOUT), TimeUnit.SECONDS);
        return builder;
    }

    public String getUnderFSType() {
        return "kodo";
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        try {
            this.mKodoClinet.copyObject(src, dst);
            return true;
        }
        catch (QiniuException e) {
            LOG.error("copy Object failed {} to {} , Msg:{}", new Object[]{src, dst, e});
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            this.mKodoClinet.createEmptyObject(key);
            return true;
        }
        catch (QiniuException e) {
            LOG.error("create empty object failed key:{} , Msg:{}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        return new KodoOutputStream(key, this.mKodoClinet, this.mUfsConf.getList(PropertyKey.TMP_DIRS, ","));
    }

    protected boolean deleteObject(String key) {
        try {
            this.mKodoClinet.deleteObject(key);
            return true;
        }
        catch (QiniuException e) {
            LOG.error("delete object failed key:{}, Msg:{}", (Object)key, (Object)e);
            return false;
        }
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    @Nullable
    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        FileListing result = this.getObjectListingChunk(key = key.equals(PATH_SEPARATOR) ? "" : key, this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf), delimiter);
        if (result != null) {
            return new KodoObjectListingChunk(result, this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf), delimiter, key);
        }
        return null;
    }

    private FileListing getObjectListingChunk(String prefix, int limit, String delimiter) {
        try {
            return this.mKodoClinet.listFiles(prefix, null, limit, delimiter);
        }
        catch (QiniuException e) {
            LOG.error("list objects failed ,Msg:{}", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            FileInfo fileInfo = this.mKodoClinet.getFileInfo(key);
            if (fileInfo == null) {
                return null;
            }
            return new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)this, key, fileInfo.hash, fileInfo.fsize, fileInfo.putTime / 10000L);
        }
        catch (QiniuException e) {
            LOG.warn("Failed to get Object {}, Msg: {}", (Object)key, (Object)e);
            return null;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions((ObjectUnderFileSystem)this, "", "", 511);
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) {
        try {
            return new KodoInputStream(key, this.mKodoClinet, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (QiniuException e) {
            LOG.error("Failed to open Object {}, Msg: {}", (Object)key, (Object)e);
            return null;
        }
    }

    protected String getRootKey() {
        return "kodo://" + this.mKodoClinet.getBucketName();
    }

    private final class KodoObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final int mLimit;
        private final String mDelimiter;
        private final String mPrefix;
        private FileListing mResult;

        KodoObjectListingChunk(FileListing result, int limit, String delimiter, String prefix) throws IOException {
            this.mLimit = limit;
            this.mDelimiter = delimiter;
            this.mResult = result;
            this.mPrefix = prefix;
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            FileInfo[] fileInfos = this.mResult.items;
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[fileInfos.length];
            int i = 0;
            for (FileInfo fileInfo : fileInfos) {
                if (fileInfo.key == null) continue;
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus((ObjectUnderFileSystem)KodoUnderFileSystem.this, fileInfo.key, fileInfo.hash, fileInfo.fsize, fileInfo.putTime / 10000L);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            if (this.mResult.commonPrefixes == null) {
                return new String[0];
            }
            return this.mResult.commonPrefixes;
        }

        @Nullable
        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (!this.mResult.isEOF()) {
                FileListing nextResult = KodoUnderFileSystem.this.mKodoClinet.listFiles(this.mPrefix, this.mResult.marker, this.mLimit, this.mDelimiter);
                return new KodoObjectListingChunk(nextResult, this.mLimit, this.mDelimiter, this.mPrefix);
            }
            return null;
        }
    }
}

