/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.kodo;

import alluxio.underfs.kodo.KodoClient;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class KodoOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(KodoOutputStream.class);
    private final String mKey;
    private final File mFile;
    private final KodoClient mKodoClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);

    public KodoOutputStream(String key, KodoClient kodoClient, List<String> tmpDirs) throws IOException {
        this.mKey = key;
        this.mKodoClient = kodoClient;
        this.mFile = new File(PathUtils.concatPath((Object)CommonUtils.getTmpDir(tmpDirs), (Object)UUID.randomUUID()));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.mFile), this.mHash));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() {
        if (this.mClosed.getAndSet(true)) {
            return;
        }
        try {
            this.mLocalOutputStream.close();
            this.mKodoClient.uploadFile(this.mKey, this.mFile);
        }
        catch (Exception e) {
            LOG.error("Failed to upload {}.", (Object)this.mKey, (Object)e);
        }
        finally {
            if (!this.mFile.delete()) {
                LOG.error("Failed to delete temporary file @ {}", (Object)this.mFile.getPath());
            }
        }
    }
}

