/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.kodo;

import alluxio.exception.status.NotFoundException;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import alluxio.underfs.kodo.KodoClient;
import com.qiniu.common.QiniuException;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodoInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(KodoInputStream.class);
    private final String mKey;
    private final KodoClient mKodoclent;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    KodoInputStream(String key, KodoClient kodoClient, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws QiniuException {
        super(multiRangeChunkSize);
        this.mKey = key;
        this.mKodoclent = kodoClient;
        this.mPos = position;
        this.mRetryPolicy = retryPolicy;
        this.mContentLength = kodoClient.getFileInfo((String)key).fsize;
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        NotFoundException lastException = null;
        String errorMessage = String.format("Failed to open key: %s", this.mKey);
        RetryPolicy retryPolicy = this.mRetryPolicy.copy();
        while (retryPolicy.attempt()) {
            try {
                return this.mKodoclent.getObject(this.mKey, startPos, endPos, this.mContentLength);
            }
            catch (NotFoundException e) {
                errorMessage = String.format("Failed to open key: %s attempts: %s error: %s", this.mKey, retryPolicy.getAttemptCount(), e.getMessage());
                lastException = e;
            }
        }
        throw new IOException(errorMessage, lastException);
    }
}

