/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.retry.RetryPolicy;
import alluxio.underfs.MultiRangeObjectInputStream;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class OBSInputStream
extends MultiRangeObjectInputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OBSInputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final ObsClient mObsClient;
    private final long mContentLength;
    private final RetryPolicy mRetryPolicy;

    OBSInputStream(String bucketName, String key, ObsClient client, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        this(bucketName, key, client, 0L, retryPolicy, multiRangeChunkSize);
    }

    OBSInputStream(String bucketName, String key, ObsClient client, long position, RetryPolicy retryPolicy, long multiRangeChunkSize) throws IOException {
        super(multiRangeChunkSize);
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mObsClient = client;
        this.mPos = position;
        ObjectMetadata meta = this.mObsClient.getObjectMetadata(this.mBucketName, key);
        this.mContentLength = meta == null ? 0L : meta.getContentLength();
        this.mRetryPolicy = retryPolicy;
    }

    protected InputStream createStream(long startPos, long endPos) throws IOException {
        GetObjectRequest req = new GetObjectRequest(this.mBucketName, this.mKey);
        req.setRangeStart(Long.valueOf(startPos));
        req.setRangeEnd(Long.valueOf(endPos < this.mContentLength ? endPos - 1L : this.mContentLength - 1L));
        ObsException lastException = null;
        while (this.mRetryPolicy.attempt()) {
            try {
                ObsObject obj = this.mObsClient.getObject(req);
                return new BufferedInputStream(obj.getObjectContent());
            }
            catch (ObsException e) {
                System.out.println(e.getResponseCode());
                LOG.warn("Attempt {} to open key {} in bucket {} failed with exception : {}", new Object[]{this.mRetryPolicy.getAttemptCount(), this.mKey, this.mBucketName, e.toString()});
                if (e.getResponseCode() != 404) {
                    throw new IOException(e);
                }
                lastException = e;
            }
        }
        throw new IOException(lastException);
    }
}

