/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ObjectLowLevelOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.obs.services.IObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.UploadPartRequest;
import com.obs.services.model.UploadPartResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OBSLowLevelOutputStream
extends ObjectLowLevelOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OBSLowLevelOutputStream.class);
    private final IObsClient mClient;
    private final List<PartEtag> mTags = Collections.synchronizedList(new ArrayList());
    protected volatile String mUploadId;
    private String mContentHash;

    public OBSLowLevelOutputStream(String bucketName, String key, IObsClient obsClient, ListeningExecutorService executor, AlluxioConfiguration ufsConf) {
        super(bucketName, key, executor, ufsConf.getBytes(PropertyKey.UNDERFS_OBS_STREAMING_UPLOAD_PARTITION_SIZE), ufsConf);
        this.mClient = (IObsClient)Preconditions.checkNotNull((Object)obsClient);
    }

    protected void uploadPartInternal(File file, int partNumber, boolean isLastPart, @Nullable String md5) throws IOException {
        try {
            UploadPartRequest uploadRequest = new UploadPartRequest();
            uploadRequest.setBucketName(this.mBucketName);
            uploadRequest.setObjectKey(this.mKey);
            uploadRequest.setUploadId(this.mUploadId);
            uploadRequest.setPartNumber(partNumber);
            uploadRequest.setFile(file);
            uploadRequest.setPartSize(Long.valueOf(file.length()));
            if (md5 != null) {
                uploadRequest.setContentMd5(md5);
            }
            UploadPartResult result = this.getClient().uploadPart(uploadRequest);
            this.mTags.add(new PartEtag(result.getEtag(), Integer.valueOf(result.getPartNumber())));
        }
        catch (ObsException e) {
            LOG.debug("failed to upload part. part number: {} upload id: {}", new Object[]{partNumber, this.mUploadId, e});
            throw new IOException(String.format("failed to upload part. key: %s part number: %s uploadId: %s", this.mKey, partNumber, this.mUploadId), e);
        }
    }

    protected void initMultiPartUploadInternal() throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.mBucketName, this.mKey);
            request.setMetadata(meta);
            this.mUploadId = this.getClient().initiateMultipartUpload(request).getUploadId();
        }
        catch (ObsException e) {
            LOG.debug("failed to init multi part upload", (Throwable)e);
            throw new IOException("failed to init multi part upload", e);
        }
    }

    protected void completeMultiPartUploadInternal() throws IOException {
        try {
            LOG.debug("complete multi part {}", (Object)this.mUploadId);
            CompleteMultipartUploadRequest completeRequest = new CompleteMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId, this.mTags);
            this.mContentHash = this.getClient().completeMultipartUpload(completeRequest).getEtag();
        }
        catch (ObsException e) {
            LOG.debug("failed to complete multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to complete multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId) + (Object)((Object)e));
        }
    }

    protected void abortMultiPartUploadInternal() throws IOException {
        try {
            AbortMultipartUploadRequest request = new AbortMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId);
            this.getClient().abortMultipartUpload(request);
        }
        catch (ObsException e) {
            LOG.debug("failed to abort multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to complete multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void createEmptyObject(String key) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(Long.valueOf(0L));
            PutObjectRequest request = new PutObjectRequest(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]));
            request.setMetadata(meta);
            this.mContentHash = this.getClient().putObject(request).getEtag();
        }
        catch (ObsException e) {
            throw new IOException(e);
        }
    }

    protected void putObject(String key, File file, @Nullable String md5) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(Long.valueOf(file.length()));
            if (md5 != null) {
                meta.setContentMd5(md5);
            }
            PutObjectRequest request = new PutObjectRequest(this.mBucketName, key, file);
            request.setMetadata(meta);
            this.mContentHash = this.getClient().putObject(request).getEtag();
        }
        catch (ObsException e) {
            throw new IOException(e);
        }
    }

    protected IObsClient getClient() {
        return this.mClient;
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }
}

