/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.ObjectMetadata;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class OBSOutputStream
extends OutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OBSOutputStream.class);
    private final String mBucketName;
    private final String mKey;
    private final File mFile;
    private final ObsClient mObsClient;
    private OutputStream mLocalOutputStream;
    private MessageDigest mHash;
    private AtomicBoolean mClosed = new AtomicBoolean(false);

    public OBSOutputStream(String bucketName, String key, ObsClient client, List<String> tmpDirs) throws IOException {
        Preconditions.checkArgument((bucketName != null && !bucketName.isEmpty() ? 1 : 0) != 0, (Object)"Bucket name must not be null or empty.");
        Preconditions.checkArgument((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"OBS object key must not be null or empty.");
        Preconditions.checkArgument((client != null ? 1 : 0) != 0, (Object)"ObsClient must not be null.");
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mObsClient = client;
        this.mFile = new File(PathUtils.concatPath((Object)CommonUtils.getTmpDir(tmpDirs), (Object)UUID.randomUUID()));
        try {
            this.mHash = MessageDigest.getInstance("MD5");
            this.mLocalOutputStream = new BufferedOutputStream(new DigestOutputStream(new FileOutputStream(this.mFile), this.mHash));
        }
        catch (NoSuchAlgorithmException e) {
            LOG.warn("Algorithm not available for MD5 hash.", (Throwable)e);
            this.mHash = null;
            this.mLocalOutputStream = new BufferedOutputStream(new FileOutputStream(this.mFile));
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.mLocalOutputStream.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.mLocalOutputStream.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mLocalOutputStream.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.mLocalOutputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mClosed.getAndSet(true)) {
            LOG.warn("OBSOutputStream is already closed");
            return;
        }
        this.mLocalOutputStream.close();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.mFile));
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(Long.valueOf(this.mFile.length()));
            if (this.mHash != null) {
                byte[] hashBytes = this.mHash.digest();
                objMeta.setContentMd5(new String(Base64.encodeBase64((byte[])hashBytes)));
            }
            this.mObsClient.putObject(this.mBucketName, this.mKey, (InputStream)in, objMeta);
        }
        catch (ObsException e) {
            LOG.error("Failed to upload {}. Temporary file @ {}", (Object)this.mKey, (Object)this.mFile.getPath());
            throw new IOException(e);
        }
        finally {
            if (!this.mFile.delete()) {
                LOG.error("Failed to delete temporary file @ {}", (Object)this.mFile.getPath());
            }
        }
    }
}

