/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.AlluxioURI;
import alluxio.PositionReader;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.retry.RetryPolicy;
import alluxio.underfs.ObjectUnderFileSystem;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.obs.OBSInputStream;
import alluxio.underfs.obs.OBSLowLevelOutputStream;
import alluxio.underfs.obs.OBSOutputStream;
import alluxio.underfs.obs.OBSPositionReader;
import alluxio.underfs.obs.ObsClientExt;
import alluxio.underfs.options.OpenOptions;
import alluxio.util.UnderFileSystemUtils;
import alluxio.util.executor.ExecutorServiceFactories;
import alluxio.util.io.PathUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.obs.services.IObsClient;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.DeleteObjectsResult;
import com.obs.services.model.KeyAndVersion;
import com.obs.services.model.ListMultipartUploadsRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.MultipartUpload;
import com.obs.services.model.MultipartUploadListing;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.fs.RenameRequest;
import com.obs.services.model.fs.RenameResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OBSUnderFileSystem
extends ObjectUnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(OBSUnderFileSystem.class);
    private static final String FOLDER_SUFFIX = PATH_SEPARATOR;
    private final ObsClient mClient;
    private final String mBucketName;
    private final String mBucketType;
    private final Supplier<ListeningExecutorService> mStreamingUploadExecutor;

    public static OBSUnderFileSystem createInstance(AlluxioURI uri, UnderFileSystemConfiguration conf) {
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OBS_ACCESS_KEY), (String)"Property %s is required to connect to OBS", (Object)PropertyKey.OBS_ACCESS_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OBS_SECRET_KEY), (String)"Property %s is required to connect to OBS", (Object)PropertyKey.OBS_SECRET_KEY);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OBS_ENDPOINT), (String)"Property %s is required to connect to OBS", (Object)PropertyKey.OBS_ENDPOINT);
        Preconditions.checkArgument((boolean)conf.isSet(PropertyKey.OBS_BUCKET_TYPE), (String)"Property %s is required to connect to OBS", (Object)PropertyKey.OBS_BUCKET_TYPE);
        String accessKey = conf.getString(PropertyKey.OBS_ACCESS_KEY);
        String secretKey = conf.getString(PropertyKey.OBS_SECRET_KEY);
        String endPoint = conf.getString(PropertyKey.OBS_ENDPOINT);
        String bucketType = conf.getString(PropertyKey.OBS_BUCKET_TYPE);
        ObsClientExt obsClient = new ObsClientExt(accessKey, secretKey, endPoint, conf.getMountSpecificConf());
        String bucketName = UnderFileSystemUtils.getBucketName((AlluxioURI)uri);
        return new OBSUnderFileSystem(uri, obsClient, bucketName, bucketType, conf);
    }

    protected OBSUnderFileSystem(AlluxioURI uri, ObsClient obsClient, String bucketName, String bucketType, UnderFileSystemConfiguration conf) {
        super(uri, conf);
        this.mClient = obsClient;
        this.mBucketName = bucketName;
        this.mBucketType = bucketType;
        this.mStreamingUploadExecutor = Suppliers.memoize(() -> {
            int numTransferThreads = conf.getInt(PropertyKey.UNDERFS_OBS_STREAMING_UPLOAD_THREADS);
            ExecutorService service = ExecutorServiceFactories.fixedThreadPool((String)"alluxio-obs-streaming-upload-worker", (int)numTransferThreads).create();
            return MoreExecutors.listeningDecorator((ExecutorService)service);
        });
    }

    public void cleanup() {
        ListMultipartUploadsRequest request;
        long cleanAge = this.mUfsConf.getMs(PropertyKey.UNDERFS_OBS_INTERMEDIATE_UPLOAD_CLEAN_AGE);
        Date cleanBefore = new Date(new Date().getTime() - cleanAge);
        MultipartUploadListing uploadListing = this.mClient.listMultipartUploads(new ListMultipartUploadsRequest(this.mBucketName));
        do {
            for (MultipartUpload upload : uploadListing.getMultipartTaskList()) {
                if (upload.getInitiatedDate().compareTo(cleanBefore) >= 0) continue;
                this.mClient.abortMultipartUpload(new AbortMultipartUploadRequest(this.mBucketName, upload.getObjectKey(), upload.getUploadId()));
            }
            request = new ListMultipartUploadsRequest(this.mBucketName);
            request.setUploadIdMarker(uploadListing.getNextUploadIdMarker());
            request.setKeyMarker(uploadListing.getKeyMarker());
        } while ((uploadListing = this.mClient.listMultipartUploads(request)).isTruncated());
    }

    public String getUnderFSType() {
        return "obs";
    }

    public PositionReader openPositionRead(String path, long fileLength) {
        return new OBSPositionReader(this.mClient, this.mBucketName, this.stripPrefixIfPresent(path), fileLength);
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    protected boolean copyObject(String src, String dst) {
        try {
            LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
            this.mClient.copyObject(this.mBucketName, src, this.mBucketName, dst);
            return true;
        }
        catch (ObsException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            System.out.println("Failed to rename file " + src + " execption:" + (Object)((Object)e));
            return false;
        }
    }

    public boolean createEmptyObject(String key) {
        try {
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(Long.valueOf(0L));
            this.mClient.putObject(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (ObsException e) {
            LOG.error("Failed to create object: {}", (Object)key, (Object)e);
            return false;
        }
    }

    protected OutputStream createObject(String key) throws IOException {
        if (this.mUfsConf.getBoolean(PropertyKey.UNDERFS_OBS_STREAMING_UPLOAD_ENABLED)) {
            return new OBSLowLevelOutputStream(this.mBucketName, key, (IObsClient)this.mClient, this.mStreamingUploadExecutor.get(), (AlluxioConfiguration)this.mUfsConf);
        }
        return new OBSOutputStream(this.mBucketName, key, this.mClient, this.mUfsConf.getList(PropertyKey.TMP_DIRS));
    }

    protected boolean deleteObject(String key) {
        try {
            this.mClient.deleteObject(this.mBucketName, key);
        }
        catch (ObsException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    protected List<String> deleteObjects(List<String> keys) throws IOException {
        KeyAndVersion[] kvs = (KeyAndVersion[])keys.stream().map(KeyAndVersion::new).toArray(KeyAndVersion[]::new);
        DeleteObjectsRequest request = new DeleteObjectsRequest(this.mBucketName, false, kvs);
        try {
            DeleteObjectsResult result = this.mClient.deleteObjects(request);
            return result.getDeletedObjectResults().stream().map(DeleteObjectsResult.DeleteObjectResult::getObjectKey).collect(Collectors.toList());
        }
        catch (ObsException e) {
            throw new IOException("Failed to delete objects", e);
        }
    }

    protected String getFolderSuffix() {
        return FOLDER_SUFFIX;
    }

    protected ObjectUnderFileSystem.ObjectListingChunk getObjectListingChunk(String key, boolean recursive) throws IOException {
        String delimiter = recursive ? "" : PATH_SEPARATOR;
        key = PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR);
        key = key.equals(PATH_SEPARATOR) ? "" : key;
        ListObjectsRequest request = new ListObjectsRequest(this.mBucketName);
        request.setPrefix(key);
        request.setMaxKeys(this.getListingChunkLength((AlluxioConfiguration)this.mUfsConf));
        request.setDelimiter(delimiter);
        ObjectListing result = this.getObjectListingChunk(request);
        if (result != null) {
            return new OBSObjectListingChunk(request, result);
        }
        return null;
    }

    private ObjectListing getObjectListingChunk(ListObjectsRequest request) {
        ObjectListing result;
        try {
            result = this.mClient.listObjects(request);
            if (this.isEnvironmentPFS() && result.getObjects().size() == 0 && !this.isDirectory(request.getPrefix())) {
                result = null;
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to list path {}", (Object)request.getPrefix(), (Object)e);
            result = null;
        }
        return result;
    }

    private boolean isDirectoryInPFS(ObjectMetadata meta) {
        int mode = Integer.parseInt(meta.getMetadata().get("mode").toString());
        if (mode < 0) {
            return false;
        }
        int ifDIr = 16384;
        return (ifDIr & mode) != 0;
    }

    private boolean isEnvironmentPFS() {
        return this.mBucketType.equalsIgnoreCase("pfs");
    }

    protected ObjectUnderFileSystem.ObjectStatus getObjectStatus(String key) {
        try {
            Date lastModifiedDate;
            ObjectMetadata meta = this.mClient.getObjectMetadata(this.mBucketName, key);
            if (meta == null) {
                return null;
            }
            if (this.isEnvironmentPFS()) {
                if (this.isDirectoryInPFS(meta)) {
                    return null;
                }
                if (!this.isDirectoryInPFS(meta) && key.endsWith(PATH_SEPARATOR)) {
                    return null;
                }
            }
            Long lastModifiedTime = (lastModifiedDate = meta.getLastModified()) == null ? null : Long.valueOf(lastModifiedDate.getTime());
            return new ObjectUnderFileSystem.ObjectStatus(key, meta.getEtag(), meta.getContentLength().longValue(), lastModifiedTime);
        }
        catch (ObsException e) {
            LOG.warn("Failed to get Object {}, return null", (Object)key, (Object)e);
            return null;
        }
    }

    public UfsStatus getStatus(String path) throws IOException {
        if (!this.isDirectory(path)) {
            ObjectUnderFileSystem.ObjectStatus status = this.getObjectStatus(this.stripPrefixIfPresent(path));
            ObjectUnderFileSystem.ObjectPermissions permissions = this.getPermissions();
            return new UfsFileStatus(path, status.getContentHash(), status.getContentLength(), status.getLastModifiedTimeMs(), permissions.getOwner(), permissions.getGroup(), permissions.getMode(), this.mUfsConf.getBytes(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT));
        }
        return this.getDirectoryStatus(path);
    }

    public boolean isDirectory(String path) throws IOException {
        if (!this.isEnvironmentPFS()) {
            return super.isDirectory(path);
        }
        if (this.isRoot(path)) {
            return true;
        }
        String pathKey = this.stripPrefixIfPresent(path);
        try {
            ObjectMetadata meta = this.mClient.getObjectMetadata(this.mBucketName, pathKey);
            return meta != null && this.isDirectoryInPFS(meta);
        }
        catch (ObsException e) {
            LOG.warn("Failed to get Object {}", (Object)pathKey, (Object)e);
            return false;
        }
    }

    protected ObjectUnderFileSystem.ObjectPermissions getPermissions() {
        return new ObjectUnderFileSystem.ObjectPermissions("", "", 511);
    }

    protected String getRootKey() {
        return "obs://" + this.mBucketName;
    }

    protected InputStream openObject(String key, OpenOptions options, RetryPolicy retryPolicy) throws IOException {
        try {
            return new OBSInputStream(this.mBucketName, key, this.mClient, options.getOffset(), retryPolicy, this.mUfsConf.getBytes(PropertyKey.UNDERFS_OBJECT_STORE_MULTI_RANGE_CHUNK_SIZE));
        }
        catch (ObsException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean renameDirectory(String src, String dst) throws IOException {
        if (!this.isEnvironmentPFS()) {
            return super.renameDirectory(src, dst);
        }
        try {
            RenameRequest request = new RenameRequest(this.mBucketName, this.stripPrefixIfPresent(src), this.stripPrefixIfPresent(dst));
            RenameResult response = this.mClient.renameFolder(request);
            if (this.isSuccessResponse(response.getStatusCode())) {
                return true;
            }
            LOG.error("Failed to rename directory from {} to {}.", (Object)src, (Object)dst);
            return false;
        }
        catch (ObsException e) {
            LOG.error("Failed to rename directory from {} to {}.", new Object[]{src, dst, e});
            return false;
        }
    }

    private boolean isSuccessResponse(int statusCode) {
        return statusCode == 200 || statusCode == 204 || statusCode == 201;
    }

    private final class OBSObjectListingChunk
    implements ObjectUnderFileSystem.ObjectListingChunk {
        final ListObjectsRequest mRequest;
        final ObjectListing mResult;

        OBSObjectListingChunk(ListObjectsRequest request, ObjectListing result) throws IOException {
            this.mRequest = request;
            this.mResult = result;
            if (this.mResult == null) {
                throw new IOException("OBS listing result is null");
            }
        }

        public ObjectUnderFileSystem.ObjectStatus[] getObjectStatuses() {
            List objects = this.mResult.getObjects();
            ObjectUnderFileSystem.ObjectStatus[] ret = new ObjectUnderFileSystem.ObjectStatus[objects.size()];
            int i = 0;
            for (ObsObject obj : objects) {
                ObjectMetadata meta = obj.getMetadata();
                Date lastModifiedDate = meta.getLastModified();
                Long lastModifiedTime = lastModifiedDate == null ? null : Long.valueOf(lastModifiedDate.getTime());
                ret[i++] = new ObjectUnderFileSystem.ObjectStatus(obj.getObjectKey(), meta.getEtag(), meta.getContentLength().longValue(), lastModifiedTime);
            }
            return ret;
        }

        public String[] getCommonPrefixes() {
            List res = this.mResult.getCommonPrefixes();
            return res.toArray(new String[0]);
        }

        public ObjectUnderFileSystem.ObjectListingChunk getNextChunk() throws IOException {
            if (this.mResult.isTruncated()) {
                this.mRequest.setMarker(this.mResult.getNextMarker());
                ObjectListing nextResult = OBSUnderFileSystem.this.mClient.listObjects(this.mRequest);
                if (nextResult != null) {
                    return new OBSObjectListingChunk(this.mRequest, nextResult);
                }
            }
            return null;
        }
    }
}

