/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.underfs.ObjectMultipartUploadOutputStream;
import com.amazonaws.SdkClientException;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.obs.services.ObsClient;
import com.obs.services.model.AbortMultipartUploadRequest;
import com.obs.services.model.CompleteMultipartUploadRequest;
import com.obs.services.model.InitiateMultipartUploadRequest;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.PartEtag;
import com.obs.services.model.PutObjectRequest;
import com.obs.services.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class OBSMultipartUploadOutputStream
extends ObjectMultipartUploadOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OBSMultipartUploadOutputStream.class);
    private final ObsClient mClient;
    private final List<PartEtag> mTags = Collections.synchronizedList(new ArrayList());
    protected volatile String mUploadId;
    private String mContentHash;

    public OBSMultipartUploadOutputStream(String bucketName, String key, ObsClient OBSClient, ListeningExecutorService executor, AlluxioConfiguration ufsConf) {
        super(bucketName, key, executor, ufsConf.getBytes(PropertyKey.UNDERFS_OBS_MULTIPART_UPLOAD_PARTITION_SIZE), ufsConf);
        this.mClient = (ObsClient)Preconditions.checkNotNull((Object)OBSClient);
    }

    protected void uploadPartInternal(byte[] buf, int partNumber, boolean isLastPart, long length) throws IOException {
        try {
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(buf, 0, (int)length));
            UploadPartRequest uploadRequest = new UploadPartRequest();
            uploadRequest.setBucketName(this.mBucketName);
            uploadRequest.setObjectKey(this.mKey);
            uploadRequest.setUploadId(this.mUploadId);
            uploadRequest.setPartNumber(partNumber);
            uploadRequest.setInput((InputStream)inputStream);
            uploadRequest.setPartSize(Long.valueOf(length));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buf, 0, (int)length);
            uploadRequest.setContentMd5(Base64.getEncoder().encodeToString(md.digest()));
            PartEtag partEtag = new PartEtag(this.getClient().uploadPart(uploadRequest).getEtag(), Integer.valueOf(partNumber));
            this.mTags.add(partEtag);
        }
        catch (SdkClientException e) {
            LOG.debug("failed to upload part.", (Throwable)e);
            throw new IOException(String.format("failed to upload part. key: %s part number: %s uploadId: %s", this.mKey, partNumber, this.mUploadId), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected void initMultipartUploadInternal() throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType("application/octet-stream");
            InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(this.mBucketName, this.mKey);
            request.setMetadata(meta);
            this.mUploadId = this.getClient().initiateMultipartUpload(request).getUploadId();
        }
        catch (SdkClientException e) {
            LOG.debug("failed to init multi part upload", (Throwable)e);
            throw new IOException("failed to init multi part upload", e);
        }
    }

    protected void completeMultipartUploadInternal() throws IOException {
        try {
            LOG.debug("complete multi part {}", (Object)this.mUploadId);
            this.mContentHash = this.getClient().completeMultipartUpload(new CompleteMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId, this.mTags)).getEtag();
        }
        catch (SdkClientException e) {
            LOG.debug("failed to complete multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to complete multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void abortMultipartUploadInternal() throws IOException {
        try {
            this.getClient().abortMultipartUpload(new AbortMultipartUploadRequest(this.mBucketName, this.mKey, this.mUploadId));
        }
        catch (SdkClientException e) {
            LOG.debug("failed to abort multi part upload", (Throwable)e);
            throw new IOException(String.format("failed to abort multi part upload, key: %s, upload id: %s", this.mKey, this.mUploadId), e);
        }
    }

    protected void createEmptyObject(String key) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentLength(Long.valueOf(0L));
            meta.setContentType("application/octet-stream");
            PutObjectRequest request = new PutObjectRequest(this.mBucketName, key, (InputStream)new ByteArrayInputStream(new byte[0]));
            request.setMetadata(meta);
            this.mContentHash = this.getClient().putObject(request).getEtag();
        }
        catch (SdkClientException e) {
            throw new IOException(e);
        }
    }

    protected void putObject(String key, byte[] buf, long length) throws IOException {
        try {
            ObjectMetadata meta = new ObjectMetadata();
            BufferedInputStream inputStream = new BufferedInputStream(new ByteArrayInputStream(buf, 0, (int)length));
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(buf, 0, (int)length);
            meta.setContentMd5(Base64.getEncoder().encodeToString(md.digest()));
            meta.setContentLength(Long.valueOf(length));
            meta.setContentType("application/octet-stream");
            PutObjectRequest putReq = new PutObjectRequest(this.mBucketName, key, (InputStream)inputStream);
            putReq.setMetadata(meta);
            this.mContentHash = this.getClient().putObject(putReq).getEtag();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    protected ObsClient getClient() {
        return this.mClient;
    }

    public Optional<String> getContentHash() {
        return Optional.ofNullable(this.mContentHash);
    }
}

