/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.AlluxioURI;
import alluxio.conf.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.obs.OBSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class OBSUnderFileSystemFactory
implements UnderFileSystemFactory {
    public UnderFileSystem create(String path, UnderFileSystemConfiguration conf) {
        Preconditions.checkNotNull((Object)path, (Object)"Unable to create UnderFileSystem instance: URI path should not be null");
        if (this.checkOBSCredentials(conf)) {
            try {
                return OBSUnderFileSystem.createInstance(new AlluxioURI(path), conf);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "OBS credentials or endpoint not available, cannot create OBS Under File System.";
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("obs://");
    }

    private boolean checkOBSCredentials(UnderFileSystemConfiguration conf) {
        return conf.isSet(PropertyKey.OBS_ACCESS_KEY) && conf.isSet(PropertyKey.OBS_SECRET_KEY) && conf.isSet(PropertyKey.OBS_ENDPOINT) && conf.isSet(PropertyKey.OBS_BUCKET_TYPE);
    }
}

