/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.obs;

import alluxio.underfs.ObjectPositionReader;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ObsObject;
import java.io.IOException;
import java.io.InputStream;

public class OBSPositionReader
extends ObjectPositionReader {
    protected final ObsClient mClient;

    public OBSPositionReader(ObsClient client, String bucketName, String path, long fileLength) {
        super(bucketName, path, fileLength);
        this.mClient = client;
    }

    protected InputStream openObjectInputStream(long position, int bytesToRead) throws IOException {
        ObsObject object;
        try {
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.mBucketName, this.mPath);
            getObjectRequest.setRangeStart(Long.valueOf(position));
            getObjectRequest.setRangeEnd(Long.valueOf(position + (long)bytesToRead - 1L));
            object = this.mClient.getObject(getObjectRequest);
        }
        catch (ObsException e) {
            String errorMessage = String.format("Failed to get object: %s bucket: %s", this.mPath, this.mBucketName);
            throw new IOException(errorMessage, e);
        }
        return object.getObjectContent();
    }
}

