/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.oss.OSSInputStream;
import alluxio.underfs.oss.OSSOutputStream;
import alluxio.util.io.PathUtils;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class OSSUnderFileSystem
extends UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final String PATH_SEPARATOR = "/";
    private final OSSClient mOssClient;
    private final String mAccessId;
    private final String mAccessKey;
    private final String mBucketName;
    private final String mBucketPrefix;
    private final String mEndPoint;

    protected OSSUnderFileSystem(AlluxioURI uri, Configuration configuration) throws Exception {
        super(uri, configuration);
        String bucketName = uri.getHost();
        Preconditions.checkArgument((boolean)configuration.containsKey("fs.oss.accessKeyId"), (Object)"Property fs.oss.accessKeyId is required to connect to OSS");
        Preconditions.checkArgument((boolean)configuration.containsKey("fs.oss.accessKeySecret"), (Object)"Property fs.oss.accessKeySecret is required to connect to OSS");
        Preconditions.checkArgument((boolean)configuration.containsKey("fs.oss.endpoint"), (Object)"Property fs.oss.endpoint is required to connect to OSS");
        this.mAccessId = configuration.get("fs.oss.accessKeyId");
        this.mAccessKey = configuration.get("fs.oss.accessKeySecret");
        this.mBucketName = bucketName;
        this.mBucketPrefix = "oss://" + this.mBucketName + PATH_SEPARATOR;
        this.mEndPoint = configuration.get("fs.oss.endpoint");
        ClientConfiguration ossClientConf = this.initializeOSSClientConfig(configuration);
        this.mOssClient = new OSSClient(this.mEndPoint, this.mAccessId, this.mAccessKey, ossClientConf);
    }

    public UnderFileSystem.UnderFSType getUnderFSType() {
        return UnderFileSystem.UnderFSType.OSS;
    }

    public void connectFromMaster(Configuration conf, String hostname) throws IOException {
    }

    public void connectFromWorker(Configuration conf, String hostname) throws IOException {
    }

    public void close() throws IOException {
    }

    public OutputStream create(String path) throws IOException {
        if (this.mkdirs(this.getParentKey(path = this.toURIPath(path)), true)) {
            return new OSSOutputStream(this.mBucketName, this.stripPrefixIfPresent(path), this.mOssClient);
        }
        return null;
    }

    public OutputStream create(String path, int blockSizeByte) throws IOException {
        LOG.warn("blocksize is not supported with OSSUnderFileSystem. Block size will be ignored.");
        return this.create(path);
    }

    public OutputStream create(String path, short replication, int blockSizeByte) throws IOException {
        LOG.warn("blocksize and replication is not supported with OSSUnderFileSystem. Will be ignored.");
        return this.create(path);
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        String[] pathsToDelete;
        if (!recursive) {
            if (this.isFolder(path) && this.listInternal(path, false).length != 0) {
                LOG.error("Unable to delete " + path + " because it is a non empty directory. Specify " + "recursive as true in order to delete non empty directories.");
                return false;
            }
            return this.deleteInternal(path);
        }
        for (String pathToDelete : pathsToDelete = this.listInternal(path, true)) {
            if (this.deleteInternal(PathUtils.concatPath((Object)path, (Object[])new Object[]{pathToDelete}))) continue;
            LOG.error("Failed to delete path {}, aborting delete.", (Object)pathToDelete);
            return false;
        }
        return this.deleteInternal(path);
    }

    public boolean exists(String path) throws IOException {
        return this.isRoot(path) || this.getObjectDetails(path) != null;
    }

    public long getBlockSizeByte(String path) throws IOException {
        return this.mConfiguration.getBytes("alluxio.user.block.size.bytes.default");
    }

    public Object getConf() {
        LOG.warn("getConf is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path) throws IOException {
        LOG.warn("getFileLocations is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        LOG.warn("getFileLocations is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public long getFileSize(String path) throws IOException {
        ObjectMetadata objectMeta = this.getObjectDetails(path);
        if (objectMeta != null) {
            return objectMeta.getContentLength();
        }
        throw new FileNotFoundException(path);
    }

    public long getModificationTimeMs(String path) throws IOException {
        ObjectMetadata objectMeta = this.getObjectDetails(path);
        if (objectMeta != null) {
            return objectMeta.getLastModified().getTime();
        }
        throw new FileNotFoundException(path);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    public boolean isFile(String path) throws IOException {
        return this.exists(path) && !this.isFolder(path);
    }

    public String[] list(String path) throws IOException {
        if (!this.exists(path) || this.isFile(path)) {
            return null;
        }
        path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR);
        return this.listInternal(path, false);
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isFolder(path)) {
            return true;
        }
        if (this.exists(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!createParent) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentKey(path);
        return this.mkdirs(parentKey, true) && this.mkdirsInternal(path);
    }

    public InputStream open(String path) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            return new OSSInputStream(this.mBucketName, path, this.mOssClient);
        }
        catch (ServiceException e) {
            LOG.error("Failed to open file: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        if (!this.exists(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        if (this.isFolder(src)) {
            String[] children;
            if (!this.copy(this.convertToFolderName(src), this.convertToFolderName(dst))) {
                return false;
            }
            for (String child : children = this.list(src)) {
                if (this.rename(PathUtils.concatPath((Object)src, (Object[])new Object[]{child}), PathUtils.concatPath((Object)dst, (Object[])new Object[]{child}))) continue;
                return false;
            }
            return this.delete(src, true);
        }
        return this.copy(src, dst) && this.deleteInternal(src);
    }

    public void setConf(Object conf) {
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setPermission(String path, String posixPerm) throws IOException {
    }

    private String convertToFolderName(String key) {
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key + FOLDER_SUFFIX;
    }

    private boolean copy(String src, String dst) {
        try {
            src = this.stripPrefixIfPresent(src);
            dst = this.stripPrefixIfPresent(dst);
            LOG.info("Copying {} to {}", (Object)src, (Object)dst);
            this.mOssClient.copyObject(this.mBucketName, src, this.mBucketName, dst);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    private boolean deleteInternal(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                this.mOssClient.deleteObject(this.mBucketName, keyAsFolder);
            } else {
                this.mOssClient.deleteObject(this.mBucketName, this.stripPrefixIfPresent(key));
            }
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    private ObjectMetadata getObjectDetails(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                return this.mOssClient.getObjectMetadata(this.mBucketName, keyAsFolder);
            }
            return this.mOssClient.getObjectMetadata(this.mBucketName, this.stripPrefixIfPresent(key));
        }
        catch (ServiceException e) {
            LOG.warn("Failed to get Object {}, return null", (Object)key, (Object)e);
            return null;
        }
    }

    private String getParentKey(String key) {
        if (this.isRoot(key)) {
            return null;
        }
        int separatorIndex = key.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return key.substring(0, separatorIndex);
    }

    private ClientConfiguration initializeOSSClientConfig(Configuration configuration) {
        ClientConfiguration ossClientConf = new ClientConfiguration();
        ossClientConf.setConnectionTimeout(configuration.getInt("alluxio.underfs.oss.connection.timeout.ms"));
        ossClientConf.setSocketTimeout(configuration.getInt("alluxio.underfs.oss.socket.timeout.ms"));
        ossClientConf.setConnectionTTL(configuration.getLong("alluxio.underfs.oss.connection.ttl"));
        ossClientConf.setMaxConnections(configuration.getInt("alluxio.underfs.oss.connection.max"));
        return ossClientConf;
    }

    private boolean isFolder(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            this.mOssClient.getObjectMetadata(this.mBucketName, keyAsFolder);
            return true;
        }
        catch (ServiceException e) {
            return false;
        }
    }

    private boolean isRoot(String key) {
        return PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR).equals(PathUtils.normalizePath((String)("oss://" + this.mBucketName), (String)PATH_SEPARATOR));
    }

    private String[] listInternal(String path, boolean recursive) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR);
            path = path.equals(PATH_SEPARATOR) ? "" : path;
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.mBucketName);
            listObjectsRequest.setPrefix(path);
            if (recursive) {
                ObjectListing listing = this.mOssClient.listObjects(listObjectsRequest);
                List objectSummaryList = listing.getObjectSummaries();
                String[] ret = new String[objectSummaryList.size()];
                for (int i = 0; i < objectSummaryList.size(); ++i) {
                    String child = this.getChildName(((OSSObjectSummary)objectSummaryList.get(i)).getKey(), path);
                    ret[i] = child = this.stripFolderSuffixIfPresent(child);
                }
                return ret;
            }
            listObjectsRequest.setDelimiter(PATH_SEPARATOR);
            HashSet<String> children = new HashSet<String>();
            ObjectListing listing = this.mOssClient.listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                String child = this.getChildName(objectSummary.getKey(), path);
                int childNameIndex = child.indexOf(PATH_SEPARATOR);
                child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
                child = this.stripFolderSuffixIfPresent(child);
                children.add(child);
            }
            return children.toArray(new String[children.size()]);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)path, (Object)e);
            return null;
        }
    }

    private String getChildName(String child, String parent) {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        LOG.error("Attempted to get childname with an invalid parent argument. Parent: {} Child: {}", (Object)parent, (Object)child);
        return null;
    }

    private boolean mkdirsInternal(String key) {
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mOssClient.putObject(this.mBucketName, keyAsFolder, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    private boolean parentExists(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        String parentKey = this.getParentKey(key);
        return parentKey != null && this.isFolder(parentKey);
    }

    private String toURIPath(String path) {
        if (!path.startsWith("oss://")) {
            path = "oss://" + this.mBucketName + path;
        }
        return path;
    }

    private String stripFolderSuffixIfPresent(String key) {
        if (key.endsWith(FOLDER_SUFFIX)) {
            return key.substring(0, key.length() - FOLDER_SUFFIX.length());
        }
        return key;
    }

    private String stripPrefixIfPresent(String key) {
        if (key.startsWith(this.mBucketPrefix)) {
            return key.substring(this.mBucketPrefix.length());
        }
        if (key.startsWith(PATH_SEPARATOR)) {
            return key.substring(PATH_SEPARATOR.length());
        }
        return key;
    }
}

