/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.oss.OSSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OSSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public UnderFileSystem create(String path, Configuration configuration, Object ufsConf) {
        Preconditions.checkNotNull((Object)path);
        Preconditions.checkNotNull((Object)configuration);
        if (this.addAndCheckOSSCredentials(configuration)) {
            try {
                return new OSSUnderFileSystem(new AlluxioURI(path), configuration);
            }
            catch (Exception e) {
                LOG.error("Failed to create OSSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "OSS Credentials not available, cannot create OSS Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path, Configuration configuration) {
        return path != null && path.startsWith("oss://");
    }

    private boolean addAndCheckOSSCredentials(Configuration configuration) {
        String endPointConf;
        String secretKeyConf;
        String accessKeyConf = "fs.oss.accessKeyId";
        if (System.getProperty(accessKeyConf) != null && configuration.get(accessKeyConf) == null) {
            configuration.set(accessKeyConf, System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.oss.accessKeySecret") != null && configuration.get(secretKeyConf) == null) {
            configuration.set(secretKeyConf, System.getProperty(secretKeyConf));
        }
        if (System.getProperty(endPointConf = "fs.oss.endpoint") != null && configuration.get(endPointConf) == null) {
            configuration.set(endPointConf, System.getProperty(endPointConf));
        }
        return configuration.get(accessKeyConf) != null && configuration.get(secretKeyConf) != null && configuration.get(endPointConf) != null;
    }
}

