/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.OSSObject;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class OSSInputStream
extends InputStream {
    private final String mBucketName;
    private final String mKey;
    private final OSSClient mOssClient;
    private final OSSObject mObject;
    private final BufferedInputStream mInputStream;

    OSSInputStream(String bucketName, String key, OSSClient client) throws IOException {
        this.mBucketName = bucketName;
        this.mKey = key;
        this.mOssClient = client;
        this.mObject = this.mOssClient.getObject(this.mBucketName, this.mKey);
        this.mInputStream = new BufferedInputStream(this.mObject.getObjectContent());
    }

    @Override
    public void close() throws IOException {
        this.mInputStream.close();
    }

    @Override
    public int read() throws IOException {
        return this.mInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.mInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }
}

