/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.oss.OSSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OSSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public UnderFileSystem create(String path, Object ufsConf) {
        Preconditions.checkNotNull((Object)path);
        if (this.addAndCheckOSSCredentials()) {
            try {
                return new OSSUnderFileSystem(new AlluxioURI(path));
            }
            catch (Exception e) {
                LOG.error("Failed to create OSSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "OSS Credentials not available, cannot create OSS Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("oss://");
    }

    private boolean addAndCheckOSSCredentials() {
        String endPointConf;
        String secretKeyConf;
        String accessKeyConf = "fs.oss.accessKeyId";
        if (System.getProperty(accessKeyConf) != null && Configuration.get((String)accessKeyConf) == null) {
            Configuration.set((String)accessKeyConf, (String)System.getProperty(accessKeyConf));
        }
        if (System.getProperty(secretKeyConf = "fs.oss.accessKeySecret") != null && Configuration.get((String)secretKeyConf) == null) {
            Configuration.set((String)secretKeyConf, (String)System.getProperty(secretKeyConf));
        }
        if (System.getProperty(endPointConf = "fs.oss.endpoint") != null && Configuration.get((String)endPointConf) == null) {
            Configuration.set((String)endPointConf, (String)System.getProperty(endPointConf));
        }
        return Configuration.get((String)accessKeyConf) != null && Configuration.get((String)secretKeyConf) != null && Configuration.get((String)endPointConf) != null;
    }
}

