/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.options.CreateOptions;
import alluxio.underfs.options.MkdirsOptions;
import alluxio.underfs.oss.OSSInputStream;
import alluxio.underfs.oss.OSSOutputStream;
import alluxio.util.CommonUtils;
import alluxio.util.io.PathUtils;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.ServiceException;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObjectSummary;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.ObjectMetadata;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class OSSUnderFileSystem
extends UnderFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String FOLDER_SUFFIX = "_$folder$";
    private static final String PATH_SEPARATOR = "/";
    private final OSSClient mClient;
    private final String mBucketName;
    private final String mBucketPrefix;

    public static OSSUnderFileSystem createInstance(AlluxioURI uri) throws Exception {
        String bucketName = uri.getHost();
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.OSS_ACCESS_KEY), (Object)("Property " + PropertyKey.OSS_ACCESS_KEY + " is required to connect to OSS"));
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.OSS_SECRET_KEY), (Object)("Property " + PropertyKey.OSS_SECRET_KEY + " is required to connect to OSS"));
        Preconditions.checkArgument((boolean)Configuration.containsKey((PropertyKey)PropertyKey.OSS_ENDPOINT_KEY), (Object)("Property " + PropertyKey.OSS_ENDPOINT_KEY + " is required to connect to OSS"));
        String accessId = Configuration.get((PropertyKey)PropertyKey.OSS_ACCESS_KEY);
        String accessKey = Configuration.get((PropertyKey)PropertyKey.OSS_SECRET_KEY);
        String bucketPrefix = "oss://" + bucketName + PATH_SEPARATOR;
        String endPoint = Configuration.get((PropertyKey)PropertyKey.OSS_ENDPOINT_KEY);
        ClientConfiguration ossClientConf = OSSUnderFileSystem.initializeOSSClientConfig();
        OSSClient ossClient = new OSSClient(endPoint, accessId, accessKey, ossClientConf);
        return new OSSUnderFileSystem(uri, ossClient, bucketName, bucketPrefix);
    }

    protected OSSUnderFileSystem(AlluxioURI uri, OSSClient ossClient, String bucketName, String bucketPrefix) {
        super(uri);
        this.mClient = ossClient;
        this.mBucketName = bucketName;
        this.mBucketPrefix = bucketPrefix;
    }

    public String getUnderFSType() {
        return "oss";
    }

    public void connectFromMaster(String hostname) throws IOException {
    }

    public void connectFromWorker(String hostname) throws IOException {
    }

    public void close() throws IOException {
    }

    public OutputStream create(String path) throws IOException {
        return this.create(path, new CreateOptions());
    }

    public OutputStream create(String path, CreateOptions options) throws IOException {
        if (this.mkdirs(this.getParentKey(path = this.toURIPath(path)), true)) {
            return new OSSOutputStream(this.mBucketName, this.stripPrefixIfPresent(path), this.mClient);
        }
        return null;
    }

    public boolean delete(String path, boolean recursive) throws IOException {
        if (!recursive) {
            String[] children = this.listInternal(path, false);
            if (children == null) {
                LOG.error("Unable to delete {} because listInternal returns null", (Object)path);
                return false;
            }
            if (this.isFolder(path) && children.length != 0) {
                LOG.error("Unable to delete {} because it is a non empty directory. Specify recursive as true in order to delete non empty directories.", (Object)path);
                return false;
            }
            return this.deleteInternal(path);
        }
        String[] pathsToDelete = this.listInternal(path, true);
        if (pathsToDelete == null) {
            LOG.error("Unable to delete {} because listInternal returns null", (Object)path);
            return false;
        }
        for (String pathToDelete : pathsToDelete) {
            if (this.deleteInternal(PathUtils.concatPath((Object)path, (Object[])new Object[]{pathToDelete}))) continue;
            LOG.error("Failed to delete path {}, aborting delete.", (Object)pathToDelete);
            return false;
        }
        return this.deleteInternal(path);
    }

    public boolean exists(String path) throws IOException {
        return this.isRoot(path) || this.getObjectDetails(path) != null;
    }

    public long getBlockSizeByte(String path) throws IOException {
        return Configuration.getBytes((PropertyKey)PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT);
    }

    public Object getConf() {
        LOG.debug("getConf is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path) throws IOException {
        LOG.debug("getFileLocations is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public List<String> getFileLocations(String path, long offset) throws IOException {
        LOG.debug("getFileLocations is not supported when using OSSUnderFileSystem, returning null.");
        return null;
    }

    public long getFileSize(String path) throws IOException {
        ObjectMetadata objectMeta = this.getObjectDetails(path);
        if (objectMeta != null) {
            return objectMeta.getContentLength();
        }
        throw new FileNotFoundException(path);
    }

    public long getModificationTimeMs(String path) throws IOException {
        ObjectMetadata objectMeta = this.getObjectDetails(path);
        if (objectMeta != null) {
            return objectMeta.getLastModified().getTime();
        }
        throw new FileNotFoundException(path);
    }

    public long getSpace(String path, UnderFileSystem.SpaceType type) throws IOException {
        return -1L;
    }

    public boolean isFile(String path) throws IOException {
        return this.exists(path) && !this.isFolder(path);
    }

    public String[] list(String path) throws IOException {
        if (!this.exists(path) || this.isFile(path)) {
            return null;
        }
        path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR);
        return this.listInternal(path, false);
    }

    public boolean mkdirs(String path, boolean createParent) throws IOException {
        return this.mkdirs(path, new MkdirsOptions().setCreateParent(createParent));
    }

    public boolean mkdirs(String path, MkdirsOptions options) throws IOException {
        if (path == null) {
            return false;
        }
        if (this.isFolder(path)) {
            return true;
        }
        if (this.exists(path)) {
            LOG.error("Cannot create directory {} because it is already a file.", (Object)path);
            return false;
        }
        if (!options.getCreateParent()) {
            if (this.parentExists(path)) {
                return this.mkdirsInternal(path);
            }
            LOG.error("Cannot create directory {} because parent does not exist", (Object)path);
            return false;
        }
        if (this.parentExists(path)) {
            return this.mkdirsInternal(path);
        }
        String parentKey = this.getParentKey(path);
        return this.mkdirs(parentKey, true) && this.mkdirsInternal(path);
    }

    public InputStream open(String path) throws IOException {
        try {
            path = this.stripPrefixIfPresent(path);
            return new OSSInputStream(this.mBucketName, path, this.mClient);
        }
        catch (ServiceException e) {
            LOG.error("Failed to open file: {}", (Object)path, (Object)e);
            return null;
        }
    }

    public boolean rename(String src, String dst) throws IOException {
        if (!this.exists(src)) {
            LOG.error("Unable to rename {} to {} because source does not exist.", (Object)src, (Object)dst);
            return false;
        }
        if (this.exists(dst)) {
            LOG.error("Unable to rename {} to {} because destination already exists.", (Object)src, (Object)dst);
            return false;
        }
        if (this.isFolder(src)) {
            if (!this.copy(this.convertToFolderName(src), this.convertToFolderName(dst))) {
                return false;
            }
            String[] children = this.list(src);
            if (children == null) {
                LOG.error("Failed to list path {}, aborting rename.", (Object)src);
                return false;
            }
            for (String child : children) {
                if (this.rename(PathUtils.concatPath((Object)src, (Object[])new Object[]{child}), PathUtils.concatPath((Object)dst, (Object[])new Object[]{child}))) continue;
                LOG.error("Failed to rename path {}, aborting rename.", (Object)child);
                return false;
            }
            return this.delete(src, true);
        }
        return this.copy(src, dst) && this.deleteInternal(src);
    }

    public void setConf(Object conf) {
    }

    public void setOwner(String path, String user, String group) {
    }

    public void setMode(String path, short mode) throws IOException {
    }

    public String getOwner(String path) throws IOException {
        return "";
    }

    public String getGroup(String path) throws IOException {
        return "";
    }

    public short getMode(String path) throws IOException {
        return 511;
    }

    private String convertToFolderName(String key) {
        if (key.endsWith(PATH_SEPARATOR)) {
            key = key.substring(0, key.length() - PATH_SEPARATOR.length());
        }
        return key + FOLDER_SUFFIX;
    }

    private boolean copy(String src, String dst) {
        try {
            src = this.stripPrefixIfPresent(src);
            dst = this.stripPrefixIfPresent(dst);
            LOG.info("Copying {} to {}", (Object)src, (Object)dst);
            this.mClient.copyObject(this.mBucketName, src, this.mBucketName, dst);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to rename file {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    private boolean deleteInternal(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                this.mClient.deleteObject(this.mBucketName, keyAsFolder);
            } else {
                this.mClient.deleteObject(this.mBucketName, this.stripPrefixIfPresent(key));
            }
        }
        catch (ServiceException e) {
            LOG.error("Failed to delete {}", (Object)key, (Object)e);
            return false;
        }
        return true;
    }

    private ObjectMetadata getObjectDetails(String key) {
        try {
            if (this.isFolder(key)) {
                String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
                return this.mClient.getObjectMetadata(this.mBucketName, keyAsFolder);
            }
            return this.mClient.getObjectMetadata(this.mBucketName, this.stripPrefixIfPresent(key));
        }
        catch (ServiceException e) {
            LOG.warn("Failed to get Object {}, return null", (Object)key, (Object)e);
            return null;
        }
    }

    private String getParentKey(String key) {
        if (this.isRoot(key)) {
            return null;
        }
        int separatorIndex = key.lastIndexOf(PATH_SEPARATOR);
        if (separatorIndex < 0) {
            return null;
        }
        return key.substring(0, separatorIndex);
    }

    private static ClientConfiguration initializeOSSClientConfig() {
        ClientConfiguration ossClientConf = new ClientConfiguration();
        ossClientConf.setConnectionTimeout(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_TIMEOUT));
        ossClientConf.setSocketTimeout(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_SOCKET_TIMEOUT));
        ossClientConf.setConnectionTTL(Configuration.getLong((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_TTL));
        ossClientConf.setMaxConnections(Configuration.getInt((PropertyKey)PropertyKey.UNDERFS_OSS_CONNECT_MAX));
        return ossClientConf;
    }

    private boolean isFolder(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            this.mClient.getObjectMetadata(this.mBucketName, keyAsFolder);
            return true;
        }
        catch (ServiceException s) {
            try {
                String path = PathUtils.normalizePath((String)this.stripPrefixIfPresent(key), (String)PATH_SEPARATOR);
                ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.mBucketName);
                listObjectsRequest.setPrefix(path);
                listObjectsRequest.setDelimiter(PATH_SEPARATOR);
                ObjectListing listing = this.mClient.listObjects(listObjectsRequest);
                if (!listing.getObjectSummaries().isEmpty()) {
                    this.mkdirsInternal(path);
                    return true;
                }
                return false;
            }
            catch (ServiceException s2) {
                return false;
            }
        }
    }

    private boolean isRoot(String key) {
        return PathUtils.normalizePath((String)key, (String)PATH_SEPARATOR).equals(PathUtils.normalizePath((String)("oss://" + this.mBucketName), (String)PATH_SEPARATOR));
    }

    private String[] listInternal(String path, boolean recursive) throws IOException {
        try {
            String child;
            path = this.stripPrefixIfPresent(path);
            path = PathUtils.normalizePath((String)path, (String)PATH_SEPARATOR);
            path = path.equals(PATH_SEPARATOR) ? "" : path;
            String delimiter = recursive ? null : PATH_SEPARATOR;
            ListObjectsRequest listObjectsRequest = new ListObjectsRequest(this.mBucketName);
            listObjectsRequest.setPrefix(path);
            listObjectsRequest.setMaxKeys(Integer.valueOf(LISTING_LENGTH));
            listObjectsRequest.setDelimiter(delimiter);
            HashSet<String> children = new HashSet<String>();
            ObjectListing listing = this.mClient.listObjects(listObjectsRequest);
            for (OSSObjectSummary objectSummary : listing.getObjectSummaries()) {
                child = this.getChildName(objectSummary.getKey(), path);
                child = CommonUtils.stripSuffixIfPresent((String)child, (String)FOLDER_SUFFIX);
                children.add(child);
            }
            for (String commonPrefix : listing.getCommonPrefixes()) {
                child = this.getChildName(commonPrefix, path);
                if (child == null) continue;
                int childNameIndex = child.lastIndexOf(PATH_SEPARATOR);
                child = childNameIndex != -1 ? child.substring(0, childNameIndex) : child;
                children.add(child);
            }
            return children.toArray(new String[children.size()]);
        }
        catch (ServiceException e) {
            LOG.error("Failed to list path {}", (Object)path, (Object)e);
            return null;
        }
    }

    private String getChildName(String child, String parent) {
        if (child.startsWith(parent)) {
            return child.substring(parent.length());
        }
        LOG.error("Attempted to get childname with an invalid parent argument. Parent: {} Child: {}", (Object)parent, (Object)child);
        return null;
    }

    private boolean mkdirsInternal(String key) {
        try {
            String keyAsFolder = this.convertToFolderName(this.stripPrefixIfPresent(key));
            ObjectMetadata objMeta = new ObjectMetadata();
            objMeta.setContentLength(0L);
            this.mClient.putObject(this.mBucketName, keyAsFolder, (InputStream)new ByteArrayInputStream(new byte[0]), objMeta);
            return true;
        }
        catch (ServiceException e) {
            LOG.error("Failed to create directory: {}", (Object)key, (Object)e);
            return false;
        }
    }

    private boolean parentExists(String key) {
        if (this.isRoot(key)) {
            return true;
        }
        String parentKey = this.getParentKey(key);
        return parentKey != null && this.isFolder(parentKey);
    }

    private String toURIPath(String path) {
        if (!path.startsWith("oss://")) {
            path = "oss://" + this.mBucketName + path;
        }
        return path;
    }

    private String stripPrefixIfPresent(String key) {
        String stripedKey = CommonUtils.stripPrefixIfPresent((String)key, (String)this.mBucketPrefix);
        if (!stripedKey.equals(key)) {
            return stripedKey;
        }
        return CommonUtils.stripPrefixIfPresent((String)key, (String)PATH_SEPARATOR);
    }

    public boolean supportsFlush() {
        return false;
    }
}

