/*
 * Decompiled with CFR 0.152.
 */
package alluxio.underfs.oss;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.oss.OSSUnderFileSystem;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class OSSUnderFileSystemFactory
implements UnderFileSystemFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public UnderFileSystem create(String path, Object ufsConf) {
        Preconditions.checkNotNull((Object)path);
        if (this.checkOSSCredentials()) {
            try {
                return OSSUnderFileSystem.createInstance(new AlluxioURI(path));
            }
            catch (Exception e) {
                LOG.error("Failed to create OSSUnderFileSystem.", (Throwable)e);
                throw Throwables.propagate((Throwable)e);
            }
        }
        String err = "OSS Credentials not available, cannot create OSS Under File System.";
        LOG.error(err);
        throw Throwables.propagate((Throwable)new IOException(err));
    }

    public boolean supportsPath(String path) {
        return path != null && path.startsWith("oss://");
    }

    private boolean checkOSSCredentials() {
        return Configuration.containsKey((PropertyKey)PropertyKey.OSS_ACCESS_KEY) && Configuration.containsKey((PropertyKey)PropertyKey.OSS_SECRET_KEY) && Configuration.containsKey((PropertyKey)PropertyKey.OSS_ENDPOINT_KEY);
    }
}

